/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.CharacterSubstitutionInterface;
import info.debatty.java.stringsimilarity.interfaces.StringDistance;

public class WeightedLevenshtein
implements StringDistance {
    private final CharacterSubstitutionInterface charsub;

    public WeightedLevenshtein(CharacterSubstitutionInterface charsub) {
        this.charsub = charsub;
    }

    public double distance(String s1, String s2) {
        int i;
        if (s1.equals(s2)) {
            return 0.0;
        }
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        double[] v0 = new double[s2.length() + 1];
        double[] v1 = new double[s2.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s1.length(); ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < s2.length(); ++j) {
                double cost = s1.charAt(i) == s2.charAt(j) ? 0.0 : this.charsub.cost(s1.charAt(i), s2.charAt(j));
                v1[j + 1] = Math.min(v1[j] + 1.0, Math.min(v0[j + 1] + 1.0, v0[j] + cost));
            }
            double[] vtemp = v0;
            v0 = v1;
            v1 = vtemp;
        }
        return v0[s2.length()];
    }
}

