/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.util;

import java.io.Serializable;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedPriorityQueue<E>
extends PriorityQueue<E>
implements Serializable {
    private final int capacity;

    public BoundedPriorityQueue(int capacity) {
        this.capacity = capacity;
    }

    public BoundedPriorityQueue() {
        this.capacity = 0;
    }

    @Override
    public final boolean add(E element) {
        if (!(element instanceof Comparable)) {
            throw new ClassCastException();
        }
        if (this.contains(element)) {
            return false;
        }
        if (this.size() < this.capacity) {
            return super.add(element);
        }
        if (this.capacity == 0) {
            return super.add(element);
        }
        if (((Comparable)element).compareTo(this.peek()) > 0) {
            this.poll();
            return super.add(element);
        }
        return false;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().isInstance(this)) {
            return false;
        }
        BoundedPriorityQueue other_queue = (BoundedPriorityQueue)other;
        return this.containsAll(other_queue) && other_queue.containsAll(this);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }
}

