/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Edge;
import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.AbstractNNDescent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedNNDescent<T>
extends AbstractNNDescent<T> {
    private SimilarityInterface<T> similarity;
    private volatile int thread_count;
    private volatile List<T> nodes;
    private volatile Graph<T> graph;
    private volatile HashMap<T, ArrayList<T>> old_lists_2;
    private volatile HashMap<T, ArrayList<T>> new_lists_2;
    private volatile ConcurrentHashMap<T, ArrayList<T>> old_lists;
    private volatile ConcurrentHashMap<T, ArrayList<T>> new_lists;

    @Override
    protected final Graph<T> nndescent(List<T> nodes, SimilarityInterface<T> similarity) {
        int c;
        this.thread_count = Runtime.getRuntime().availableProcessors() + 1;
        ExecutorService executor = Executors.newFixedThreadPool(this.thread_count);
        this.similarity = similarity;
        this.nodes = nodes;
        this.graph = new Graph();
        this.graph.setK(this.getK());
        this.old_lists = new ConcurrentHashMap(nodes.size());
        this.new_lists = new ConcurrentHashMap(nodes.size());
        for (T v : nodes) {
            this.graph.put(v, this.randomNeighborList(nodes, v));
        }
        int iterations = 0;
        do {
            ++iterations;
            for (int i = 0; i < nodes.size(); ++i) {
                T v = nodes.get(i);
                this.old_lists.put(v, this.pickFalses(v, this.graph.getNeighbors(v)));
                this.new_lists.put(v, this.pickTruesAndMark(v, this.graph.getNeighbors(v)));
            }
            this.old_lists_2 = this.reverse(nodes, this.old_lists);
            this.new_lists_2 = this.reverse(nodes, this.new_lists);
            ArrayList<Future<Integer>> list = new ArrayList<Future<Integer>>();
            for (int t = 0; t < this.thread_count; ++t) {
                list.add(executor.submit(new NNThread(t)));
            }
            c = 0;
            for (Future future : list) {
                try {
                    c += ((Integer)future.get()).intValue();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {}
            }
        } while (!((double)c <= this.getDelta() * (double)nodes.size() * (double)this.getK()) && iterations < this.getMaxIterations());
        executor.shutdown();
        this.new_lists = null;
        this.new_lists_2 = null;
        this.nodes = null;
        this.old_lists = null;
        this.old_lists_2 = null;
        return this.graph;
    }

    @Override
    protected final Set<Edge> getSetInstance(int size) {
        return Collections.synchronizedSet(new HashSet(size));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NNThread
    implements Callable<Integer> {
        private final int slice;

        NNThread(int slice) {
            this.slice = slice;
        }

        @Override
        public Integer call() {
            int c = 0;
            int start = this.slice * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.thread_count;
            int end = (this.slice + 1) * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.thread_count;
            if (this.slice == ThreadedNNDescent.this.thread_count - 1) {
                end = ThreadedNNDescent.this.nodes.size();
            }
            for (int i = start; i < end; ++i) {
                Object v = ThreadedNNDescent.this.nodes.get(i);
                ThreadedNNDescent.this.old_lists.put(v, ThreadedNNDescent.this.union((ArrayList)ThreadedNNDescent.this.old_lists.get(v), ThreadedNNDescent.this.sample((ArrayList)ThreadedNNDescent.this.old_lists_2.get(v), (int)(ThreadedNNDescent.this.getRho() * (double)ThreadedNNDescent.this.getK()))));
                ThreadedNNDescent.this.new_lists.put(v, ThreadedNNDescent.this.union((ArrayList)ThreadedNNDescent.this.new_lists.get(v), ThreadedNNDescent.this.sample((ArrayList)ThreadedNNDescent.this.new_lists_2.get(v), (int)(ThreadedNNDescent.this.getRho() * (double)ThreadedNNDescent.this.getK()))));
                for (int j = 0; j < ((ArrayList)ThreadedNNDescent.this.new_lists.get(v)).size(); ++j) {
                    double s;
                    Object u2;
                    int k;
                    Object u1 = ((ArrayList)ThreadedNNDescent.this.new_lists.get(v)).get(j);
                    for (k = j + 1; k < ((ArrayList)ThreadedNNDescent.this.new_lists.get(u1)).size(); ++k) {
                        u2 = ((ArrayList)ThreadedNNDescent.this.new_lists.get(u1)).get(k);
                        s = ThreadedNNDescent.this.similarity.similarity(u1, u2);
                        c += ThreadedNNDescent.this.updateNL(ThreadedNNDescent.this.graph.getNeighbors(u1), u2, s);
                        c += ThreadedNNDescent.this.updateNL(ThreadedNNDescent.this.graph.getNeighbors(u2), u1, s);
                    }
                    for (k = 0; k < ((ArrayList)ThreadedNNDescent.this.old_lists.get(v)).size(); ++k) {
                        u2 = ((ArrayList)ThreadedNNDescent.this.old_lists.get(v)).get(k);
                        if (u1.equals(u2)) continue;
                        s = ThreadedNNDescent.this.similarity.similarity(u1, u2);
                        c += ThreadedNNDescent.this.updateNL(ThreadedNNDescent.this.graph.getNeighbors(u1), u2, s);
                        c += ThreadedNNDescent.this.updateNL(ThreadedNNDescent.this.graph.getNeighbors(u2), u1, s);
                    }
                }
            }
            return c;
        }
    }
}

