/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.BruteBlock;
import info.debatty.java.graphs.build.GraphBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedBrute<T>
extends GraphBuilder<T> {
    public static final int NODES_PER_BLOCK = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedBrute.class);

    @Override
    protected final Graph<T> computeGraph(List<T> nodes, int k, SimilarityInterface<T> similarity) {
        int n = nodes.size();
        int cores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        ArrayList<Future<T>> results = new ArrayList<Future<T>>();
        for (int i = 0; i < n; i += 1000) {
            for (int j = 0; j <= i; j += 1000) {
                results.add(executor.submit(new BruteBlock<T>(nodes, k, similarity, i, j)));
            }
        }
        Graph graph = new Graph();
        for (T t : nodes) {
            graph.put(t, new NeighborList(k));
        }
        for (Future future : results) {
            try {
                Graph subgraph = (Graph)future.get();
                for (Map.Entry entry : subgraph.entrySet()) {
                    graph.getNeighbors(entry.getKey()).addAll(entry.getValue());
                }
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOGGER.error("Exception", (Throwable)ex);
            }
        }
        return graph;
    }
}

