/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import info.debatty.java.graphs.build.GraphBuilder;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartitioningGraphBuilder<T>
extends GraphBuilder<T> {
    private static final int DEFAULT_OVERSAMPLING = 2;
    private static final int DEFAULT_N_PARTITIONS = 4;
    private int oversampling = 2;
    private int n_partitions = 4;
    private GraphBuilder internal_builder = new Brute();

    public final int getOversampling() {
        return this.oversampling;
    }

    public final void setOversampling(int oversampling) {
        this.oversampling = oversampling;
    }

    public final int getNPartitions() {
        return this.n_partitions;
    }

    public final void setNPartitions(int n_partitions) {
        this.n_partitions = n_partitions;
    }

    public final GraphBuilder getInternalBuilder() {
        return this.internal_builder;
    }

    public final void setInternalBuilder(GraphBuilder internal_builder) {
        this.internal_builder = internal_builder;
    }

    @Override
    protected final Graph<T> computeGraph(List<T> nodes, int k, SimilarityInterface<T> similarity) {
        List<T>[] partitioning = this.partition(nodes);
        Graph<T> neighborlists = new Graph<T>(nodes.size());
        for (T node : nodes) {
            neighborlists.put(node, new NeighborList(this.getK()));
        }
        this.internal_builder.setK(k);
        this.internal_builder.setSimilarity(similarity);
        for (int p = 0; p < this.n_partitions; ++p) {
            if (partitioning[p] == null || partitioning[p].isEmpty()) continue;
            Graph<T> subgraph = this.internal_builder.computeGraph(partitioning[p]);
            for (Map.Entry<T, NeighborList> e : subgraph.entrySet()) {
                neighborlists.getNeighbors(e.getKey()).addAll(e.getValue());
            }
        }
        return neighborlists;
    }

    protected abstract List<T>[] partition(List<T> var1);
}

