/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Edge;
import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.GraphBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNNDescent<T>
extends GraphBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNNDescent.class);
    private static final int MIN_SIZE = 500;
    private static final double DEFAULT_RHO = 0.5;
    private static final double DEFAULT_DELTA = 0.001;
    private double rho = 0.5;
    private double delta = 0.001;
    private int max_iterations = Integer.MAX_VALUE;
    private SimilarityInterface<T> similarity;
    private Set<Edge> processed;

    AbstractNNDescent() {
    }

    public final double getRho() {
        return this.rho;
    }

    public final void setRho(double rho) {
        if (rho > 1.0 || rho <= 0.0) {
            throw new IllegalArgumentException("0 < rho <= 1.0");
        }
        this.rho = rho;
    }

    public final double getDelta() {
        return this.delta;
    }

    public final void setDelta(double delta) {
        if (this.rho >= 1.0 || this.rho <= 0.0) {
            throw new IllegalArgumentException("0 < delta < 1.0");
        }
        this.delta = delta;
    }

    public final int getMaxIterations() {
        return this.max_iterations;
    }

    public final void setMaxIterations(int max_iterations) {
        if (max_iterations < 0) {
            throw new IllegalArgumentException("max_iterations must be positive!");
        }
        this.max_iterations = max_iterations;
    }

    protected final ArrayList<T> union(ArrayList<T> l1, ArrayList<T> l2) {
        ArrayList<T> r = new ArrayList<T>();
        for (T n : l1) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        for (T n : l2) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        return r;
    }

    protected final NeighborList randomNeighborList(List<T> nodes, T for_node) {
        NeighborList nl = new NeighborList(this.getK());
        Random r = new Random();
        while (nl.size() < this.getK()) {
            T node = nodes.get(r.nextInt(nodes.size()));
            if (node.equals(for_node)) continue;
            double s = this.similarity.similarity(node, for_node);
            nl.add(new Neighbor<T>(node, s));
        }
        return nl;
    }

    protected final ArrayList<T> pickFalses(T node, NeighborList neighbor_list) {
        ArrayList falses = new ArrayList();
        for (Neighbor n : neighbor_list) {
            Edge<T> edge = new Edge<T>(node, n);
            if (!this.processed.contains(edge)) continue;
            falses.add(n.getNode());
        }
        return falses;
    }

    protected final ArrayList<T> pickTruesAndMark(T node, NeighborList neighbor_list) {
        ArrayList r = new ArrayList();
        for (Neighbor n : neighbor_list) {
            Edge<T> edge = new Edge<T>(node, n);
            if (this.processed.contains(edge) || !(Math.random() < this.rho)) continue;
            this.processed.add(edge);
            r.add(n.getNode());
        }
        return r;
    }

    protected final HashMap<T, ArrayList<T>> reverse(List<T> nodes, Map<T, ArrayList<T>> lists) {
        HashMap reverse = new HashMap(nodes.size());
        for (T n : nodes) {
            reverse.put(n, new ArrayList());
        }
        for (T node : nodes) {
            ArrayList<T> list = lists.get(node);
            for (T other_node : list) {
                ((ArrayList)reverse.get(other_node)).add(node);
            }
        }
        return reverse;
    }

    protected final ArrayList<T> sample(ArrayList<T> nodes, int count) {
        Random r = new Random();
        while (nodes.size() > count) {
            nodes.remove(r.nextInt(nodes.size()));
        }
        return nodes;
    }

    protected final int updateNL(NeighborList nl, T n, double similarity) {
        Neighbor<T> neighbor = new Neighbor<T>(n, similarity);
        if (nl.add(neighbor)) {
            return 1;
        }
        return 0;
    }

    private Graph<T> makeFullyLinked(List<T> nodes) {
        Graph<T> neighborlists = new Graph<T>(nodes.size());
        for (T node : nodes) {
            NeighborList neighborlist = new NeighborList(this.getK());
            for (T other_node : nodes) {
                if (node.equals(other_node)) continue;
                neighborlist.add(new Neighbor<T>(other_node, this.similarity.similarity(node, other_node)));
            }
            neighborlists.put(node, neighborlist);
        }
        return neighborlists;
    }

    @Override
    protected Graph<T> computeGraph(List<T> nodes, int k, SimilarityInterface<T> similarity) {
        if (nodes.size() < 500) {
            LOGGER.warn("NNDescent should be used for large graphs!");
        }
        this.similarity = similarity;
        if (nodes.size() <= k + 1) {
            return this.makeFullyLinked(nodes);
        }
        this.processed = this.getSetInstance(nodes.size() * k);
        return this.nndescent(nodes, similarity);
    }

    abstract Graph<T> nndescent(List<T> var1, SimilarityInterface<T> var2);

    protected abstract Set<Edge> getSetInstance(int var1);
}

