/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.FastSearchConfig;
import info.debatty.java.graphs.FastSearchResult;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.OnlineConfig;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.StatisticsContainer;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T>
implements Serializable {
    public static final int DEFAULT_K = 10;
    private final HashMap<T, NeighborList> map;
    private SimilarityInterface<T> similarity;
    private int k = 10;
    private final transient Random rand = new Random();
    private transient ArrayList<T> nodes;
    private static final String GEXF_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gexf xmlns=\"http://www.gexf.net/1.2draft\" version=\"1.2\">\n<meta>\n<creator>info.debatty.java.graphs.Graph</creator>\n<description></description>\n</meta>\n<graph mode=\"static\" defaultedgetype=\"directed\">\n";
    private static final int HASH_BASE = 3;
    private static final int HASH_MULT = 23;

    public Graph(Graph<T> origin) {
        this.k = origin.k;
        this.similarity = origin.similarity;
        this.map = new HashMap(origin.size());
        for (T node : origin.getNodes()) {
            this.map.put(node, new NeighborList(origin.getNeighbors(node)));
        }
    }

    public Graph(int k) {
        this.k = k;
        this.map = new HashMap();
    }

    public Graph() {
        this.map = new HashMap();
    }

    public final SimilarityInterface<T> getSimilarity() {
        return this.similarity;
    }

    public final void setSimilarity(SimilarityInterface<T> similarity) {
        this.similarity = similarity;
    }

    public final int getK() {
        return this.k;
    }

    public final void setK(int k) {
        this.k = k;
    }

    public final NeighborList getNeighbors(T node) {
        return this.map.get(node);
    }

    public final T first() throws NoSuchElementException {
        return this.getNodes().iterator().next();
    }

    public final T getRandomNode() {
        return this.getNodes().get(this.rand.nextInt(this.getNodes().size()));
    }

    public final void prune(double threshold) {
        for (NeighborList nl : this.map.values()) {
            nl.prune(threshold);
        }
    }

    public final ArrayList<Graph<T>> connectedComponents() {
        ArrayList<Graph<T>> subgraphs = new ArrayList<Graph<T>>();
        LinkedList<T> nodes_to_process = new LinkedList<T>(this.map.keySet());
        while (!nodes_to_process.isEmpty()) {
            T n = nodes_to_process.peek();
            if (n == null) continue;
            Graph<T> subgraph = new Graph<T>();
            subgraphs.add(subgraph);
            this.addAndFollow(subgraph, n, nodes_to_process);
        }
        return subgraphs;
    }

    private void addAndFollow(Graph<T> subgraph, T node, LinkedList<T> nodes_to_process) {
        nodes_to_process.remove(node);
        NeighborList neighborlist = this.getNeighbors(node);
        subgraph.put(node, neighborlist);
        if (neighborlist == null) {
            return;
        }
        for (Neighbor neighbor : this.getNeighbors(node)) {
            if (subgraph.containsKey(neighbor.getNode())) continue;
            this.addAndFollow(subgraph, neighbor.getNode(), nodes_to_process);
        }
    }

    public final ArrayList<Graph<T>> stronglyConnectedComponents() {
        Stack<NodeParent> explored_nodes = new Stack<NodeParent>();
        Index index = new Index();
        HashMap bookkeeping = new HashMap(this.map.size());
        ArrayList<Graph<T>> connected_components = new ArrayList<Graph<T>>();
        for (T n : this.map.keySet()) {
            ArrayList<T> connected_component;
            if (bookkeeping.containsKey(n) || (connected_component = this.strongConnect(n, explored_nodes, index, bookkeeping)) == null) continue;
            Graph<T> subgraph = new Graph<T>(connected_component.size());
            for (T node : connected_component) {
                subgraph.put(node, this.getNeighbors(node));
            }
            connected_components.add(subgraph);
        }
        return connected_components;
    }

    private ArrayList<T> strongConnect(T starting_point, Stack<NodeParent> explored_nodes, Index index, HashMap<T, NodeProperty> bookkeeping) {
        Object node;
        Stack<NodeParent> nodes_to_process = new Stack<NodeParent>();
        nodes_to_process.push(new NodeParent(starting_point, null));
        while (!nodes_to_process.empty()) {
            NodeParent node_and_parent = (NodeParent)nodes_to_process.pop();
            Object node2 = node_and_parent.node;
            bookkeeping.put(node2, new NodeProperty(index.value(), index.value()));
            index.inc();
            explored_nodes.add(node_and_parent);
            for (Neighbor neighbor : this.getNeighbors(node2)) {
                Object neighbor_node = neighbor.getNode();
                if (!this.containsKey(neighbor_node) || this.getNeighbors(neighbor_node) == null || bookkeeping.containsKey(neighbor_node)) continue;
                boolean skip = false;
                for (NodeParent node_in_queue : nodes_to_process) {
                    if (!node_in_queue.node.equals(neighbor_node)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                nodes_to_process.push(new NodeParent(neighbor_node, node2));
            }
        }
        for (NodeParent node_and_parent : explored_nodes) {
            node = node_and_parent.parent;
            Object child = node_and_parent.node;
            if (node == null) continue;
            bookkeeping.get(node).lowlink = Math.min(bookkeeping.get(node).lowlink, bookkeeping.get(child).lowlink);
        }
        for (NodeParent node_and_parent : explored_nodes) {
            Object other_node;
            node = node_and_parent.node;
            if (bookkeeping.get(node).lowlink != bookkeeping.get(node).index) continue;
            ArrayList<Object> connected_component = new ArrayList<Object>();
            do {
                other_node = explored_nodes.pop().node;
                bookkeeping.get(other_node).onstack = false;
                connected_component.add(other_node);
            } while (!starting_point.equals(other_node));
            return connected_component;
        }
        return null;
    }

    public final NeighborList put(T node, NeighborList neighborlist) {
        return this.map.put(node, neighborlist);
    }

    public final boolean containsKey(T node) {
        return this.map.containsKey(node);
    }

    public final int size() {
        return this.map.size();
    }

    public final Iterable<Map.Entry<T, NeighborList>> entrySet() {
        return this.map.entrySet();
    }

    public final ArrayList<T> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<T>(this.map.keySet());
        }
        return this.nodes;
    }

    public final LinkedList<T> findNeighbors(LinkedList<T> starting_points, int depth) {
        LinkedList<T> neighbors = new LinkedList<T>();
        neighbors.addAll(starting_points);
        for (Object start_node : starting_points) {
            this.findNeighbors(neighbors, start_node, depth);
        }
        return neighbors;
    }

    private void findNeighbors(LinkedList<T> candidates, T node, int current_depth) {
        NeighborList nl = this.getNeighbors(node);
        if (nl == null) {
            return;
        }
        for (Neighbor n : nl) {
            if (candidates.contains(n.getNode())) continue;
            candidates.add(n.getNode());
            if (current_depth <= 0) continue;
            this.findNeighbors(candidates, n.getNode(), current_depth - 1);
        }
    }

    public final HashMap<T, NeighborList> getHashMap() {
        return this.map;
    }

    public final NeighborList search(T query, int k) throws InterruptedException, ExecutionException {
        int procs = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(procs);
        ArrayList<Future<NeighborList>> results = new ArrayList<Future<NeighborList>>();
        for (int i = 0; i < procs; ++i) {
            int start = this.getNodes().size() / procs * i;
            int n = Math.min(this.getNodes().size() / procs * (i + 1), this.getNodes().size());
            results.add(pool.submit(new SearchTask(this.nodes, query, start, n)));
        }
        NeighborList neighbors = new NeighborList(k);
        for (Future future : results) {
            neighbors.addAll((Collection)future.get());
        }
        pool.shutdown();
        return neighbors;
    }

    public final FastSearchResult fastSearch(T query) {
        return this.fastSearch(query, FastSearchConfig.getDefault());
    }

    public final FastSearchResult fastSearch(T query, FastSearchConfig conf) {
        return this.fastSearch(query, conf, this.getRandomNode());
    }

    public final FastSearchResult fastSearch(T query, FastSearchConfig conf, T start) {
        FastSearchResult<T> result = new FastSearchResult<T>(conf.getK());
        int max_similarities = (int)((double)this.map.size() / conf.getSpeedup());
        if (conf.getK() >= this.map.size() || max_similarities >= this.map.size()) {
            for (T node : this.map.keySet()) {
                result.getNeighbors().add(new Neighbor<T>(node, this.similarity.similarity(query, node)));
                result.incSimilarities();
            }
            return result;
        }
        T current_node = start;
        HashMap<T, Double> visited_nodes = new HashMap<T, Double>(max_similarities);
        double highest_similarity = 0.0;
        while (result.getSimilarities() < max_similarities) {
            if (!visited_nodes.containsKey(current_node)) {
                double current_node_similarity = this.similarity.similarity(query, current_node);
                result.incSimilarities();
                if (!(current_node_similarity < highest_similarity / conf.getExpansion())) {
                    while (result.getSimilarities() < max_similarities) {
                        double neighbor_similarity;
                        T neighbor;
                        NeighborList nl = this.getNeighbors(current_node);
                        if (nl == null) {
                            if (conf.isRestartAtBoundary()) {
                                result.incBoundaryRestarts();
                                break;
                            }
                            result.setBoundaryNode(current_node);
                            return result;
                        }
                        Object best_neighbor = null;
                        double best_neighbor_similarity = current_node_similarity;
                        for (int i = 0; i < conf.getLongJumps(); ++i) {
                            neighbor = this.getRandomNode();
                            if (visited_nodes.containsKey(neighbor)) continue;
                            neighbor_similarity = this.similarity.similarity(query, neighbor);
                            result.incSimilarities();
                            visited_nodes.put(neighbor, neighbor_similarity);
                            if (!(neighbor_similarity > current_node_similarity)) continue;
                            best_neighbor = neighbor;
                            best_neighbor_similarity = neighbor_similarity;
                            break;
                        }
                        Iterator y_nl_iterator = nl.iterator();
                        while (y_nl_iterator.hasNext()) {
                            neighbor = ((Neighbor)y_nl_iterator.next()).getNode();
                            if (visited_nodes.containsKey(neighbor)) continue;
                            neighbor_similarity = this.similarity.similarity(query, neighbor);
                            result.incSimilarities();
                            visited_nodes.put(neighbor, neighbor_similarity);
                            if (!(neighbor_similarity > best_neighbor_similarity)) continue;
                            best_neighbor = neighbor;
                            best_neighbor_similarity = neighbor_similarity;
                            break;
                        }
                        if (best_neighbor_similarity > highest_similarity) {
                            highest_similarity = best_neighbor_similarity;
                        }
                        if (best_neighbor == null) break;
                        current_node = best_neighbor;
                    }
                }
            }
            current_node = this.getRandomNode();
            result.incRestarts();
        }
        for (Map.Entry entry : visited_nodes.entrySet()) {
            result.getNeighbors().add(new Neighbor(entry.getKey(), (Double)entry.getValue()));
        }
        return result;
    }

    public final void writeGEXF(String filename) throws FileNotFoundException, IOException {
        OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(filename)));
        out.write(GEXF_HEADER);
        out.write("<nodes>\n");
        int node_id = 0;
        IdentityHashMap<T, Integer> node_registry = new IdentityHashMap<T, Integer>();
        for (T node : this.map.keySet()) {
            node_registry.put(node, node_id);
            out.write("<node id=\"" + node_id + "\" label=\"" + node.toString() + "\" />\n");
            ++node_id;
        }
        out.write("</nodes>\n");
        out.write("<edges>\n");
        int i = 0;
        for (T source : this.map.keySet()) {
            int source_id = (Integer)node_registry.get(source);
            for (Neighbor target : this.getNeighbors(source)) {
                int target_id = (Integer)node_registry.get(target.getNode());
                out.write("<edge id=\"" + i + "\" source=\"" + source_id + "\" target=\"" + target_id + "\" weight=\"" + target.getSimilarity() + "\" />\n");
                ++i;
            }
        }
        out.write("</edges>\n");
        out.write("</graph>\n</gexf>");
        ((Writer)out).close();
    }

    public final int add(T new_node) {
        if (this.containsKey(new_node)) {
            throw new IllegalArgumentException("This graph already contains this node");
        }
        NeighborList nl = new NeighborList(this.k);
        for (T other_node : this.getNodes()) {
            double sim = this.similarity.similarity(new_node, other_node);
            nl.add(new Neighbor<T>(other_node, sim));
            this.getNeighbors(other_node).add(new Neighbor<T>(new_node, sim));
        }
        this.put(new_node, nl);
        this.nodes = null;
        return this.size() - 1;
    }

    public final void fastAdd(T node) {
        this.fastAdd(node, OnlineConfig.getDefault());
    }

    public final void fastAdd(T new_node, OnlineConfig conf) {
        if (this.containsKey(new_node)) {
            throw new IllegalArgumentException("This graph already contains this node");
        }
        conf.setK(this.getK());
        NeighborList neighborlist = this.fastSearch(new_node, conf).getNeighbors();
        this.put(new_node, neighborlist);
        LinkedList analyze = new LinkedList();
        LinkedList next_analyze = new LinkedList();
        HashMap visited = new HashMap();
        for (Neighbor neighbor : this.getNeighbors(new_node)) {
            analyze.add(neighbor.getNode());
        }
        StatisticsContainer stats = new StatisticsContainer();
        for (int d = 0; d < conf.getUpdateDepth(); ++d) {
            while (!analyze.isEmpty()) {
                Object other = analyze.pop();
                NeighborList other_neighborlist = this.getNeighbors(other);
                for (Neighbor other_neighbor : other_neighborlist) {
                    if (visited.containsKey(other_neighbor.getNode())) continue;
                    next_analyze.add(other_neighbor.getNode());
                }
                stats.incAddSimilarities();
                other_neighborlist.add(new Neighbor<T>(new_node, this.similarity.similarity(new_node, other)));
                visited.put(other, Boolean.TRUE);
            }
            analyze = next_analyze;
            next_analyze = new LinkedList();
        }
        this.nodes = null;
    }

    public final void fastRemove(T node_to_remove) {
        this.fastRemove(node_to_remove, OnlineConfig.getDefault());
    }

    public final void fastRemove(T node_to_remove, OnlineConfig conf) {
        LinkedList<T> nodes_to_update = new LinkedList<T>();
        for (T node : this.getNodes()) {
            NeighborList nl = this.getNeighbors(node);
            if (!nl.containsNode(node_to_remove)) continue;
            nodes_to_update.add(node);
            nl.removeNode(node_to_remove);
        }
        LinkedList<T> initial_candidates = new LinkedList<T>();
        initial_candidates.add(node_to_remove);
        initial_candidates.addAll(nodes_to_update);
        LinkedList candidates = this.findNeighbors(initial_candidates, conf.getUpdateDepth());
        while (candidates.contains(node_to_remove)) {
            candidates.remove(node_to_remove);
        }
        StatisticsContainer stats = new StatisticsContainer();
        for (Object node_to_update : nodes_to_update) {
            NeighborList nl_to_update = this.getNeighbors(node_to_update);
            for (Object candidate : candidates) {
                if (candidate.equals(node_to_update)) continue;
                stats.incRemoveSimilarities();
                double sim = this.similarity.similarity(node_to_update, candidate);
                nl_to_update.add(new Neighbor(candidate, sim));
            }
        }
        this.map.remove(node_to_remove);
        this.nodes = null;
    }

    public final int compare(Graph<T> other) {
        int correct_edges = 0;
        for (T node : this.map.keySet()) {
            correct_edges += this.getNeighbors(node).countCommons(other.getNeighbors(node));
        }
        return correct_edges;
    }

    public final String toString() {
        return this.map.toString();
    }

    public final int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.map.hashCode();
        return hash;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Graph other = (Graph)obj;
        return this.map.equals(other.map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchTask
    implements Callable<NeighborList> {
        private final ArrayList<T> nodes;
        private final T query;
        private final int start;
        private final int stop;

        SearchTask(ArrayList<T> nodes, T query, int start, int stop) {
            this.nodes = nodes;
            this.query = query;
            this.start = start;
            this.stop = stop;
        }

        @Override
        public NeighborList call() throws Exception {
            NeighborList nl = new NeighborList(Graph.this.k);
            for (int i = this.start; i < this.stop; ++i) {
                Object other = Graph.this.getNodes().get(i);
                nl.add(new Neighbor(other, Graph.this.similarity.similarity(this.query, other)));
            }
            return nl;
        }
    }

    private static class NodeProperty {
        private int index;
        private int lowlink;
        private boolean onstack;

        NodeProperty(int index, int lowlink) {
            this.index = index;
            this.lowlink = lowlink;
            this.onstack = true;
        }
    }

    private static class Index {
        private int value;

        private Index() {
        }

        public int value() {
            return this.value;
        }

        public void inc() {
            ++this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeParent {
        private T node;
        private T parent;

        NodeParent(T node, T parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

