/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import java.io.Serializable;

public class FastSearchConfig
implements Serializable {
    public static final double DEFAULT_SEARCH_SPEEDUP = 4.0;
    public static final double DEFAULT_SEARCH_EXPANSION = 1.2;
    public static final int DEFAULT_SEARCH_RANDOM_JUMPS = 2;
    private int k;
    private double speedup;
    private int long_jumps;
    private double expansion;
    private boolean restart_at_boundary = true;

    public static FastSearchConfig getDefault() {
        FastSearchConfig conf = new FastSearchConfig();
        conf.expansion = 1.2;
        conf.speedup = 4.0;
        conf.long_jumps = 2;
        conf.restart_at_boundary = true;
        conf.k = 1;
        return conf;
    }

    public static FastSearchConfig getNaive() {
        FastSearchConfig conf = new FastSearchConfig();
        conf.expansion = Double.POSITIVE_INFINITY;
        conf.speedup = 4.0;
        conf.long_jumps = 0;
        conf.restart_at_boundary = false;
        conf.k = 1;
        return conf;
    }

    public final int getK() {
        return this.k;
    }

    public final void setK(int k) {
        this.k = k;
    }

    public final double getSpeedup() {
        return this.speedup;
    }

    public final void setSpeedup(double speedup) {
        if (speedup <= 1.0) {
            throw new IllegalArgumentException("Speedup should be > 1.0");
        }
        this.speedup = speedup;
    }

    public final int getLongJumps() {
        return this.long_jumps;
    }

    public final void setLongJumps(int long_jumps) {
        this.long_jumps = long_jumps;
    }

    public final double getExpansion() {
        return this.expansion;
    }

    public final void setExpansion(double expansion) {
        this.expansion = expansion;
    }

    public final boolean isRestartAtBoundary() {
        return this.restart_at_boundary;
    }

    public final void setRestartAtBoundary(boolean restart_at_boundary) {
        this.restart_at_boundary = restart_at_boundary;
    }
}

