/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java8.StepdefBody;
import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.java.TypeIntrospector;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;

public class Java8StepDefinition
implements StepDefinition {
    private final Pattern pattern;
    private final long timeoutMillis;
    private final StepdefBody body;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final StackTraceElement location;
    private final List<ParameterInfo> parameterInfos;
    private final Method method;

    public Java8StepDefinition(Pattern pattern, long timeoutMillis, StepdefBody body, TypeIntrospector typeIntrospector) throws Exception {
        this.pattern = pattern;
        this.timeoutMillis = timeoutMillis;
        this.body = body;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.location = new Exception().getStackTrace()[3];
        Class<?> bodyClass = body.getClass();
        Type genericInterface = bodyClass.getGenericInterfaces()[0];
        Type[] typeArguments = genericInterface instanceof ParameterizedType ? ((ParameterizedType)genericInterface).getActualTypeArguments() : typeIntrospector.getGenericTypes(bodyClass);
        this.parameterInfos = ParameterInfo.fromTypes((Type[])typeArguments);
        Class[] parameterTypes = new Class[this.parameterInfos.size()];
        for (int i = 0; i < this.parameterInfos.size(); ++i) {
            parameterTypes[i] = Object.class;
        }
        this.method = bodyClass.getDeclaredMethod("accept", parameterTypes);
    }

    public List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step.getName());
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) throws IndexOutOfBoundsException {
        return this.parameterInfos.get(n);
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        Utils.invoke((Object)this.body, (Method)this.method, (long)this.timeoutMillis, (Object[])args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public boolean isScenarioScoped() {
        return true;
    }
}

