/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Address;
import org.hl7.fhir.AdministrativeGender;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.Extension;
import org.hl7.fhir.HumanName;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Patient.Contact", propOrder={"relationship", "name", "telecom", "address", "gender", "organization", "period"})
public class PatientContact
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected List<CodeableConcept> relationship;
    protected HumanName name;
    protected List<ContactPoint> telecom;
    protected Address address;
    protected AdministrativeGender gender;
    protected Reference organization;
    protected Period period;

    public List<CodeableConcept> getRelationship() {
        if (this.relationship == null) {
            this.relationship = new ArrayList<CodeableConcept>();
        }
        return this.relationship;
    }

    public HumanName getName() {
        return this.name;
    }

    public void setName(HumanName value) {
        this.name = value;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address value) {
        this.address = value;
    }

    public AdministrativeGender getGender() {
        return this.gender;
    }

    public void setGender(AdministrativeGender value) {
        this.gender = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public PatientContact withRelationship(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getRelationship().add(value);
            }
        }
        return this;
    }

    public PatientContact withRelationship(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getRelationship().addAll(values);
        }
        return this;
    }

    public PatientContact withName(HumanName value) {
        this.setName(value);
        return this;
    }

    public PatientContact withTelecom(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getTelecom().add(value);
            }
        }
        return this;
    }

    public PatientContact withTelecom(Collection<ContactPoint> values) {
        if (values != null) {
            this.getTelecom().addAll(values);
        }
        return this;
    }

    public PatientContact withAddress(Address value) {
        this.setAddress(value);
        return this;
    }

    public PatientContact withGender(AdministrativeGender value) {
        this.setGender(value);
        return this;
    }

    public PatientContact withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public PatientContact withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    @Override
    public PatientContact withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public PatientContact withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public PatientContact withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public PatientContact withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public PatientContact withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        PatientContact that = (PatientContact)object;
        List<CodeableConcept> lhsRelationship = this.relationship != null && !this.relationship.isEmpty() ? this.getRelationship() : null;
        List<CodeableConcept> rhsRelationship = that.relationship != null && !that.relationship.isEmpty() ? that.getRelationship() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relationship", lhsRelationship), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relationship", rhsRelationship), lhsRelationship, rhsRelationship, this.relationship != null && !this.relationship.isEmpty(), that.relationship != null && !that.relationship.isEmpty())) {
            return false;
        }
        HumanName lhsName = this.getName();
        HumanName rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        List<ContactPoint> lhsTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        List<ContactPoint> rhsTelecom = that.telecom != null && !that.telecom.isEmpty() ? that.getTelecom() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"telecom", lhsTelecom), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"telecom", rhsTelecom), lhsTelecom, rhsTelecom, this.telecom != null && !this.telecom.isEmpty(), that.telecom != null && !that.telecom.isEmpty())) {
            return false;
        }
        Address lhsAddress = this.getAddress();
        Address rhsAddress = that.getAddress();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"address", (Object)lhsAddress), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"address", (Object)rhsAddress), (Object)lhsAddress, (Object)rhsAddress, this.address != null, that.address != null)) {
            return false;
        }
        AdministrativeGender lhsGender = this.getGender();
        AdministrativeGender rhsGender = that.getGender();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"gender", (Object)lhsGender), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"gender", (Object)rhsGender), (Object)lhsGender, (Object)rhsGender, this.gender != null, that.gender != null)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization, this.organization != null, that.organization != null)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod, this.period != null, that.period != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<CodeableConcept> theRelationship = this.relationship != null && !this.relationship.isEmpty() ? this.getRelationship() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relationship", theRelationship), currentHashCode, theRelationship, this.relationship != null && !this.relationship.isEmpty());
        HumanName theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"telecom", theTelecom), currentHashCode, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Address theAddress = this.getAddress();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"address", (Object)theAddress), currentHashCode, (Object)theAddress, this.address != null);
        AdministrativeGender theGender = this.getGender();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"gender", (Object)theGender), currentHashCode, (Object)theGender, this.gender != null);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization, this.organization != null);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod, this.period != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<CodeableConcept> theRelationship = this.relationship != null && !this.relationship.isEmpty() ? this.getRelationship() : null;
        strategy.appendField(locator, (Object)this, "relationship", buffer, theRelationship, this.relationship != null && !this.relationship.isEmpty());
        HumanName theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        strategy.appendField(locator, (Object)this, "telecom", buffer, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Address theAddress = this.getAddress();
        strategy.appendField(locator, (Object)this, "address", buffer, (Object)theAddress, this.address != null);
        AdministrativeGender theGender = this.getGender();
        strategy.appendField(locator, (Object)this, "gender", buffer, (Object)theGender, this.gender != null);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization, this.organization != null);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod, this.period != null);
        return buffer;
    }

    public void setRelationship(List<CodeableConcept> value) {
        this.relationship = value;
    }

    public void setTelecom(List<ContactPoint> value) {
        this.telecom = value;
    }
}

