/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationAdministrationDosage;
import org.hl7.fhir.MedicationAdministrationStatus;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationAdministration", propOrder={"identifier", "status", "medicationCodeableConcept", "medicationReference", "patient", "encounter", "effectiveTimeDateTime", "effectiveTimePeriod", "practitioner", "prescription", "wasNotGiven", "reasonNotGiven", "reasonGiven", "device", "note", "dosage"})
public class MedicationAdministration
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected MedicationAdministrationStatus status;
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    @XmlElement(required=true)
    protected Reference patient;
    protected Reference encounter;
    protected DateTime effectiveTimeDateTime;
    protected Period effectiveTimePeriod;
    protected Reference practitioner;
    protected Reference prescription;
    protected Boolean wasNotGiven;
    protected List<CodeableConcept> reasonNotGiven;
    protected List<CodeableConcept> reasonGiven;
    protected List<Reference> device;
    protected List<Annotation> note;
    protected MedicationAdministrationDosage dosage;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationAdministrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationAdministrationStatus value) {
        this.status = value;
    }

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getEffectiveTimeDateTime() {
        return this.effectiveTimeDateTime;
    }

    public void setEffectiveTimeDateTime(DateTime value) {
        this.effectiveTimeDateTime = value;
    }

    public Period getEffectiveTimePeriod() {
        return this.effectiveTimePeriod;
    }

    public void setEffectiveTimePeriod(Period value) {
        this.effectiveTimePeriod = value;
    }

    public Reference getPractitioner() {
        return this.practitioner;
    }

    public void setPractitioner(Reference value) {
        this.practitioner = value;
    }

    public Reference getPrescription() {
        return this.prescription;
    }

    public void setPrescription(Reference value) {
        this.prescription = value;
    }

    public Boolean getWasNotGiven() {
        return this.wasNotGiven;
    }

    public void setWasNotGiven(Boolean value) {
        this.wasNotGiven = value;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotGiven;
    }

    public List<CodeableConcept> getReasonGiven() {
        if (this.reasonGiven == null) {
            this.reasonGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonGiven;
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationAdministrationDosage getDosage() {
        return this.dosage;
    }

    public void setDosage(MedicationAdministrationDosage value) {
        this.dosage = value;
    }

    public MedicationAdministration withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withStatus(MedicationAdministrationStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationAdministration withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationAdministration withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationAdministration withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationAdministration withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public MedicationAdministration withEffectiveTimeDateTime(DateTime value) {
        this.setEffectiveTimeDateTime(value);
        return this;
    }

    public MedicationAdministration withEffectiveTimePeriod(Period value) {
        this.setEffectiveTimePeriod(value);
        return this;
    }

    public MedicationAdministration withPractitioner(Reference value) {
        this.setPractitioner(value);
        return this;
    }

    public MedicationAdministration withPrescription(Reference value) {
        this.setPrescription(value);
        return this;
    }

    public MedicationAdministration withWasNotGiven(Boolean value) {
        this.setWasNotGiven(value);
        return this;
    }

    public MedicationAdministration withReasonNotGiven(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonNotGiven().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withReasonNotGiven(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonNotGiven().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withReasonGiven(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonGiven().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withReasonGiven(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonGiven().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withDevice(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getDevice().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withDevice(Collection<Reference> values) {
        if (values != null) {
            this.getDevice().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withDosage(MedicationAdministrationDosage value) {
        this.setDosage(value);
        return this;
    }

    @Override
    public MedicationAdministration withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationAdministration withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationAdministration withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationAdministration withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationAdministration withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationAdministration withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationAdministration withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationAdministration withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationAdministration withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationAdministration withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationAdministration withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationAdministration that = (MedicationAdministration)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        MedicationAdministrationStatus lhsStatus = this.getStatus();
        MedicationAdministrationStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationCodeableConcept", (Object)lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationCodeableConcept", (Object)rhsMedicationCodeableConcept), (Object)lhsMedicationCodeableConcept, (Object)rhsMedicationCodeableConcept, this.medicationCodeableConcept != null, that.medicationCodeableConcept != null)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationReference", (Object)lhsMedicationReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationReference", (Object)rhsMedicationReference), (Object)lhsMedicationReference, (Object)rhsMedicationReference, this.medicationReference != null, that.medicationReference != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        DateTime lhsEffectiveTimeDateTime = this.getEffectiveTimeDateTime();
        DateTime rhsEffectiveTimeDateTime = that.getEffectiveTimeDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"effectiveTimeDateTime", (Object)lhsEffectiveTimeDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"effectiveTimeDateTime", (Object)rhsEffectiveTimeDateTime), (Object)lhsEffectiveTimeDateTime, (Object)rhsEffectiveTimeDateTime, this.effectiveTimeDateTime != null, that.effectiveTimeDateTime != null)) {
            return false;
        }
        Period lhsEffectiveTimePeriod = this.getEffectiveTimePeriod();
        Period rhsEffectiveTimePeriod = that.getEffectiveTimePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"effectiveTimePeriod", (Object)lhsEffectiveTimePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"effectiveTimePeriod", (Object)rhsEffectiveTimePeriod), (Object)lhsEffectiveTimePeriod, (Object)rhsEffectiveTimePeriod, this.effectiveTimePeriod != null, that.effectiveTimePeriod != null)) {
            return false;
        }
        Reference lhsPractitioner = this.getPractitioner();
        Reference rhsPractitioner = that.getPractitioner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"practitioner", (Object)lhsPractitioner), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"practitioner", (Object)rhsPractitioner), (Object)lhsPractitioner, (Object)rhsPractitioner, this.practitioner != null, that.practitioner != null)) {
            return false;
        }
        Reference lhsPrescription = this.getPrescription();
        Reference rhsPrescription = that.getPrescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"prescription", (Object)lhsPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"prescription", (Object)rhsPrescription), (Object)lhsPrescription, (Object)rhsPrescription, this.prescription != null, that.prescription != null)) {
            return false;
        }
        Boolean lhsWasNotGiven = this.getWasNotGiven();
        Boolean rhsWasNotGiven = that.getWasNotGiven();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"wasNotGiven", (Object)lhsWasNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"wasNotGiven", (Object)rhsWasNotGiven), (Object)lhsWasNotGiven, (Object)rhsWasNotGiven, this.wasNotGiven != null, that.wasNotGiven != null)) {
            return false;
        }
        List<CodeableConcept> lhsReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        List<CodeableConcept> rhsReasonNotGiven = that.reasonNotGiven != null && !that.reasonNotGiven.isEmpty() ? that.getReasonNotGiven() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonNotGiven", lhsReasonNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonNotGiven", rhsReasonNotGiven), lhsReasonNotGiven, rhsReasonNotGiven, this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty(), that.reasonNotGiven != null && !that.reasonNotGiven.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsReasonGiven = this.reasonGiven != null && !this.reasonGiven.isEmpty() ? this.getReasonGiven() : null;
        List<CodeableConcept> rhsReasonGiven = that.reasonGiven != null && !that.reasonGiven.isEmpty() ? that.getReasonGiven() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonGiven", lhsReasonGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonGiven", rhsReasonGiven), lhsReasonGiven, rhsReasonGiven, this.reasonGiven != null && !this.reasonGiven.isEmpty(), that.reasonGiven != null && !that.reasonGiven.isEmpty())) {
            return false;
        }
        List<Reference> lhsDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        List<Reference> rhsDevice = that.device != null && !that.device.isEmpty() ? that.getDevice() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"device", lhsDevice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"device", rhsDevice), lhsDevice, rhsDevice, this.device != null && !this.device.isEmpty(), that.device != null && !that.device.isEmpty())) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"note", lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        MedicationAdministrationDosage lhsDosage = this.getDosage();
        MedicationAdministrationDosage rhsDosage = that.getDosage();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dosage", (Object)lhsDosage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dosage", (Object)rhsDosage), (Object)lhsDosage, (Object)rhsDosage, this.dosage != null, that.dosage != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        MedicationAdministrationStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationCodeableConcept", (Object)theMedicationCodeableConcept), currentHashCode, (Object)theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationReference", (Object)theMedicationReference), currentHashCode, (Object)theMedicationReference, this.medicationReference != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter, this.encounter != null);
        DateTime theEffectiveTimeDateTime = this.getEffectiveTimeDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"effectiveTimeDateTime", (Object)theEffectiveTimeDateTime), currentHashCode, (Object)theEffectiveTimeDateTime, this.effectiveTimeDateTime != null);
        Period theEffectiveTimePeriod = this.getEffectiveTimePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"effectiveTimePeriod", (Object)theEffectiveTimePeriod), currentHashCode, (Object)theEffectiveTimePeriod, this.effectiveTimePeriod != null);
        Reference thePractitioner = this.getPractitioner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"practitioner", (Object)thePractitioner), currentHashCode, (Object)thePractitioner, this.practitioner != null);
        Reference thePrescription = this.getPrescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"prescription", (Object)thePrescription), currentHashCode, (Object)thePrescription, this.prescription != null);
        Boolean theWasNotGiven = this.getWasNotGiven();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"wasNotGiven", (Object)theWasNotGiven), currentHashCode, (Object)theWasNotGiven, this.wasNotGiven != null);
        List<CodeableConcept> theReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonNotGiven", theReasonNotGiven), currentHashCode, theReasonNotGiven, this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty());
        List<CodeableConcept> theReasonGiven = this.reasonGiven != null && !this.reasonGiven.isEmpty() ? this.getReasonGiven() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonGiven", theReasonGiven), currentHashCode, theReasonGiven, this.reasonGiven != null && !this.reasonGiven.isEmpty());
        List<Reference> theDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"device", theDevice), currentHashCode, theDevice, this.device != null && !this.device.isEmpty());
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        MedicationAdministrationDosage theDosage = this.getDosage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dosage", (Object)theDosage), currentHashCode, (Object)theDosage, this.dosage != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        MedicationAdministrationStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, (Object)theMedicationCodeableConcept, this.medicationCodeableConcept != null);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, (Object)theMedicationReference, this.medicationReference != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter, this.encounter != null);
        DateTime theEffectiveTimeDateTime = this.getEffectiveTimeDateTime();
        strategy.appendField(locator, (Object)this, "effectiveTimeDateTime", buffer, (Object)theEffectiveTimeDateTime, this.effectiveTimeDateTime != null);
        Period theEffectiveTimePeriod = this.getEffectiveTimePeriod();
        strategy.appendField(locator, (Object)this, "effectiveTimePeriod", buffer, (Object)theEffectiveTimePeriod, this.effectiveTimePeriod != null);
        Reference thePractitioner = this.getPractitioner();
        strategy.appendField(locator, (Object)this, "practitioner", buffer, (Object)thePractitioner, this.practitioner != null);
        Reference thePrescription = this.getPrescription();
        strategy.appendField(locator, (Object)this, "prescription", buffer, (Object)thePrescription, this.prescription != null);
        Boolean theWasNotGiven = this.getWasNotGiven();
        strategy.appendField(locator, (Object)this, "wasNotGiven", buffer, (Object)theWasNotGiven, this.wasNotGiven != null);
        List<CodeableConcept> theReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        strategy.appendField(locator, (Object)this, "reasonNotGiven", buffer, theReasonNotGiven, this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty());
        List<CodeableConcept> theReasonGiven = this.reasonGiven != null && !this.reasonGiven.isEmpty() ? this.getReasonGiven() : null;
        strategy.appendField(locator, (Object)this, "reasonGiven", buffer, theReasonGiven, this.reasonGiven != null && !this.reasonGiven.isEmpty());
        List<Reference> theDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        strategy.appendField(locator, (Object)this, "device", buffer, theDevice, this.device != null && !this.device.isEmpty());
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        MedicationAdministrationDosage theDosage = this.getDosage();
        strategy.appendField(locator, (Object)this, "dosage", buffer, (Object)theDosage, this.dosage != null);
        return buffer;
    }

    public void setIdentifier(List<Identifier> value) {
        this.identifier = value;
    }

    public void setReasonNotGiven(List<CodeableConcept> value) {
        this.reasonNotGiven = value;
    }

    public void setReasonGiven(List<CodeableConcept> value) {
        this.reasonGiven = value;
    }

    public void setDevice(List<Reference> value) {
        this.device = value;
    }

    public void setNote(List<Annotation> value) {
        this.note = value;
    }
}

