/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.ProvenanceRelatedAgent;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Provenance.Agent", propOrder={"role", "actor", "userId", "relatedAgent"})
public class ProvenanceAgent
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Coding role;
    protected Reference actor;
    protected Identifier userId;
    protected List<ProvenanceRelatedAgent> relatedAgent;

    public Coding getRole() {
        return this.role;
    }

    public void setRole(Coding value) {
        this.role = value;
    }

    public Reference getActor() {
        return this.actor;
    }

    public void setActor(Reference value) {
        this.actor = value;
    }

    public Identifier getUserId() {
        return this.userId;
    }

    public void setUserId(Identifier value) {
        this.userId = value;
    }

    public List<ProvenanceRelatedAgent> getRelatedAgent() {
        if (this.relatedAgent == null) {
            this.relatedAgent = new ArrayList<ProvenanceRelatedAgent>();
        }
        return this.relatedAgent;
    }

    public ProvenanceAgent withRole(Coding value) {
        this.setRole(value);
        return this;
    }

    public ProvenanceAgent withActor(Reference value) {
        this.setActor(value);
        return this;
    }

    public ProvenanceAgent withUserId(Identifier value) {
        this.setUserId(value);
        return this;
    }

    public ProvenanceAgent withRelatedAgent(ProvenanceRelatedAgent ... values) {
        if (values != null) {
            for (ProvenanceRelatedAgent value : values) {
                this.getRelatedAgent().add(value);
            }
        }
        return this;
    }

    public ProvenanceAgent withRelatedAgent(Collection<ProvenanceRelatedAgent> values) {
        if (values != null) {
            this.getRelatedAgent().addAll(values);
        }
        return this;
    }

    @Override
    public ProvenanceAgent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProvenanceAgent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProvenanceAgent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProvenanceAgent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProvenanceAgent withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ProvenanceAgent that = (ProvenanceAgent)object;
        Coding lhsRole = this.getRole();
        Coding rhsRole = that.getRole();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"role", (Object)lhsRole), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"role", (Object)rhsRole), (Object)lhsRole, (Object)rhsRole, this.role != null, that.role != null)) {
            return false;
        }
        Reference lhsActor = this.getActor();
        Reference rhsActor = that.getActor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"actor", (Object)lhsActor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"actor", (Object)rhsActor), (Object)lhsActor, (Object)rhsActor, this.actor != null, that.actor != null)) {
            return false;
        }
        Identifier lhsUserId = this.getUserId();
        Identifier rhsUserId = that.getUserId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"userId", (Object)lhsUserId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"userId", (Object)rhsUserId), (Object)lhsUserId, (Object)rhsUserId, this.userId != null, that.userId != null)) {
            return false;
        }
        List<ProvenanceRelatedAgent> lhsRelatedAgent = this.relatedAgent != null && !this.relatedAgent.isEmpty() ? this.getRelatedAgent() : null;
        List<ProvenanceRelatedAgent> rhsRelatedAgent = that.relatedAgent != null && !that.relatedAgent.isEmpty() ? that.getRelatedAgent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relatedAgent", lhsRelatedAgent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relatedAgent", rhsRelatedAgent), lhsRelatedAgent, rhsRelatedAgent, this.relatedAgent != null && !this.relatedAgent.isEmpty(), that.relatedAgent != null && !that.relatedAgent.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Coding theRole = this.getRole();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"role", (Object)theRole), currentHashCode, (Object)theRole, this.role != null);
        Reference theActor = this.getActor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"actor", (Object)theActor), currentHashCode, (Object)theActor, this.actor != null);
        Identifier theUserId = this.getUserId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"userId", (Object)theUserId), currentHashCode, (Object)theUserId, this.userId != null);
        List<ProvenanceRelatedAgent> theRelatedAgent = this.relatedAgent != null && !this.relatedAgent.isEmpty() ? this.getRelatedAgent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relatedAgent", theRelatedAgent), currentHashCode, theRelatedAgent, this.relatedAgent != null && !this.relatedAgent.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Coding theRole = this.getRole();
        strategy.appendField(locator, (Object)this, "role", buffer, (Object)theRole, this.role != null);
        Reference theActor = this.getActor();
        strategy.appendField(locator, (Object)this, "actor", buffer, (Object)theActor, this.actor != null);
        Identifier theUserId = this.getUserId();
        strategy.appendField(locator, (Object)this, "userId", buffer, (Object)theUserId, this.userId != null);
        List<ProvenanceRelatedAgent> theRelatedAgent = this.relatedAgent != null && !this.relatedAgent.isEmpty() ? this.getRelatedAgent() : null;
        strategy.appendField(locator, (Object)this, "relatedAgent", buffer, theRelatedAgent, this.relatedAgent != null && !this.relatedAgent.isEmpty());
        return buffer;
    }
}

