/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.MedicationPackage;
import org.hl7.fhir.MedicationProduct;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Medication", propOrder={"code", "isBrand", "manufacturer", "product", "_package"})
public class Medication
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept code;
    protected Boolean isBrand;
    protected Reference manufacturer;
    protected MedicationProduct product;
    @XmlElement(name="package")
    protected MedicationPackage _package;

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Boolean getIsBrand() {
        return this.isBrand;
    }

    public void setIsBrand(Boolean value) {
        this.isBrand = value;
    }

    public Reference getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(Reference value) {
        this.manufacturer = value;
    }

    public MedicationProduct getProduct() {
        return this.product;
    }

    public void setProduct(MedicationProduct value) {
        this.product = value;
    }

    public MedicationPackage getPackage() {
        return this._package;
    }

    public void setPackage(MedicationPackage value) {
        this._package = value;
    }

    public Medication withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Medication withIsBrand(Boolean value) {
        this.setIsBrand(value);
        return this;
    }

    public Medication withManufacturer(Reference value) {
        this.setManufacturer(value);
        return this;
    }

    public Medication withProduct(MedicationProduct value) {
        this.setProduct(value);
        return this;
    }

    public Medication withPackage(MedicationPackage value) {
        this.setPackage(value);
        return this;
    }

    @Override
    public Medication withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Medication withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Medication withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Medication withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Medication withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Medication withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Medication withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Medication withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Medication withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Medication withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Medication withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Medication that = (Medication)object;
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Boolean lhsIsBrand = this.getIsBrand();
        Boolean rhsIsBrand = that.getIsBrand();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"isBrand", (Object)lhsIsBrand), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"isBrand", (Object)rhsIsBrand), (Object)lhsIsBrand, (Object)rhsIsBrand, this.isBrand != null, that.isBrand != null)) {
            return false;
        }
        Reference lhsManufacturer = this.getManufacturer();
        Reference rhsManufacturer = that.getManufacturer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"manufacturer", (Object)lhsManufacturer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"manufacturer", (Object)rhsManufacturer), (Object)lhsManufacturer, (Object)rhsManufacturer, this.manufacturer != null, that.manufacturer != null)) {
            return false;
        }
        MedicationProduct lhsProduct = this.getProduct();
        MedicationProduct rhsProduct = that.getProduct();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"product", (Object)lhsProduct), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"product", (Object)rhsProduct), (Object)lhsProduct, (Object)rhsProduct, this.product != null, that.product != null)) {
            return false;
        }
        MedicationPackage lhsPackage = this.getPackage();
        MedicationPackage rhsPackage = that.getPackage();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"_package", (Object)lhsPackage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"_package", (Object)rhsPackage), (Object)lhsPackage, (Object)rhsPackage, this._package != null, that._package != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"code", (Object)theCode), currentHashCode, (Object)theCode, this.code != null);
        Boolean theIsBrand = this.getIsBrand();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"isBrand", (Object)theIsBrand), currentHashCode, (Object)theIsBrand, this.isBrand != null);
        Reference theManufacturer = this.getManufacturer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"manufacturer", (Object)theManufacturer), currentHashCode, (Object)theManufacturer, this.manufacturer != null);
        MedicationProduct theProduct = this.getProduct();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"product", (Object)theProduct), currentHashCode, (Object)theProduct, this.product != null);
        MedicationPackage thePackage = this.getPackage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"_package", (Object)thePackage), currentHashCode, (Object)thePackage, this._package != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode, this.code != null);
        Boolean theIsBrand = this.getIsBrand();
        strategy.appendField(locator, (Object)this, "isBrand", buffer, (Object)theIsBrand, this.isBrand != null);
        Reference theManufacturer = this.getManufacturer();
        strategy.appendField(locator, (Object)this, "manufacturer", buffer, (Object)theManufacturer, this.manufacturer != null);
        MedicationProduct theProduct = this.getProduct();
        strategy.appendField(locator, (Object)this, "product", buffer, (Object)theProduct, this.product != null);
        MedicationPackage thePackage = this.getPackage();
        strategy.appendField(locator, (Object)this, "_package", buffer, (Object)thePackage, this._package != null);
        return buffer;
    }
}

