/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.util.ArrayList;
import java.util.List;
import org.opencds.cqf.cql.engine.runtime.CodeSystem;
import org.opencds.cqf.cql.engine.runtime.Vocabulary;

public class ValueSet
extends Vocabulary {
    private List<CodeSystem> codeSystems = new ArrayList<CodeSystem>();

    public ValueSet withId(String id) {
        this.setId(id);
        return this;
    }

    public ValueSet withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public ValueSet withName(String name) {
        this.setName(name);
        return this;
    }

    public Iterable<CodeSystem> getCodeSystems() {
        return this.codeSystems;
    }

    public void setCodeSystems(List<CodeSystem> codeSystems) {
        this.codeSystems = new ArrayList<CodeSystem>();
        if (codeSystems != null) {
            for (CodeSystem cs : codeSystems) {
                if (cs == null) continue;
                this.addCodeSystem(cs);
            }
        }
    }

    public ValueSet withCodeSystems(List<CodeSystem> codeSystems) {
        this.setCodeSystems(codeSystems);
        return this;
    }

    public void addCodeSystem(CodeSystem codeSystem) {
        if (codeSystem == null) {
            throw new IllegalArgumentException("codeSystem is required");
        }
        this.codeSystems.add(codeSystem);
    }

    public ValueSet withCodeSystem(CodeSystem codeSystem) {
        this.addCodeSystem(codeSystem);
        return this;
    }

    public CodeSystem getCodeSystem(String id) {
        if (id == null) {
            return null;
        }
        for (CodeSystem cs : this.codeSystems) {
            if (!id.equals(cs.getId())) continue;
            return cs;
        }
        return null;
    }

    public CodeSystem getCodeSystem(String id, String version) {
        if (id == null) {
            return null;
        }
        for (CodeSystem cs : this.codeSystems) {
            if (!id.equals(cs.getId()) || (version != null || cs.getVersion() != null) && (version == null || !version.equals(cs.getVersion()))) continue;
            return cs;
        }
        return null;
    }

    @Override
    public Boolean equivalent(Object other) {
        if (!(other instanceof ValueSet)) {
            return false;
        }
        ValueSet otherV = (ValueSet)other;
        Boolean equivalent = super.equivalent(other) != false && this.codeSystems.size() == otherV.codeSystems.size();
        if (equivalent.booleanValue()) {
            for (CodeSystem cs : this.codeSystems) {
                CodeSystem otherC = otherV.getCodeSystem(cs.getId());
                if (otherC != null) continue;
                return false;
            }
        }
        return equivalent;
    }

    @Override
    public Boolean equal(Object other) {
        if (!(other instanceof ValueSet)) {
            return false;
        }
        ValueSet otherV = (ValueSet)other;
        Boolean equal = super.equal(other) != false && this.codeSystems.size() == otherV.codeSystems.size();
        if (equal.booleanValue()) {
            for (CodeSystem cs : this.codeSystems) {
                CodeSystem otherC = otherV.getCodeSystem(cs.getId(), cs.getVersion());
                if (otherC != null) continue;
                return false;
            }
        }
        return equal;
    }
}

