/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.exception.InvalidDateTime;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;

public class DateTime
extends BaseTemporal {
    private ZoneOffset zoneOffset;
    private OffsetDateTime dateTime;

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        if (dateTime.getYear() < 1) {
            throw new InvalidDateTime(String.format("The year: %d falls below the accepted bounds of 0001-9999.", dateTime.getYear()));
        }
        if (dateTime.getYear() > 9999) {
            throw new InvalidDateTime(String.format("The year: %d falls above the accepted bounds of 0001-9999.", dateTime.getYear()));
        }
        this.dateTime = dateTime;
    }

    public DateTime withPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    public DateTime(OffsetDateTime dateTime) {
        this.setDateTime(dateTime);
        this.precision = Precision.MILLISECOND;
        this.zoneOffset = this.toZoneOffset(dateTime);
    }

    public DateTime(OffsetDateTime dateTime, Precision precision) {
        this.setDateTime(dateTime);
        this.precision = precision;
        this.zoneOffset = this.toZoneOffset(dateTime);
    }

    public DateTime(String dateString, ZoneOffset offset) {
        if (offset == null) {
            throw new CqlException("Cannot pass a null offset");
        }
        this.zoneOffset = offset;
        if (((String)dateString).matches("T[0-2]\\d:[0-5]\\d:[0-5]\\d\\.\\d{3}(\\+|-)\\d{2}$")) {
            dateString = (String)dateString + ":00";
        }
        int size = 0;
        if (((String)dateString).contains("T")) {
            String[] datetimeSplit = ((String)dateString).split("T");
            size += datetimeSplit[0].split("-").length;
            String[] tzSplit = ((String)dateString).contains("Z") ? ((String)dateString).split("Z") : datetimeSplit[1].split("[+-]");
            size += tzSplit[0].split(":").length;
            if (tzSplit[0].contains(".")) {
                ++size;
            }
            this.precision = Precision.fromDateTimeIndex(size - 1);
            if (tzSplit.length == 1 && !((String)dateString).contains("Z")) {
                dateString = TemporalHelper.autoCompleteDateTimeString((String)dateString, this.precision);
                dateString = (String)dateString + offset.getId();
            }
        } else {
            this.precision = Precision.fromDateTimeIndex((size += ((String)dateString).split("-").length) - 1);
            dateString = TemporalHelper.autoCompleteDateTimeString((String)dateString, this.precision);
            dateString = (String)dateString + offset.getId();
        }
        this.setDateTime(OffsetDateTime.parse((CharSequence)dateString));
    }

    public DateTime(BigDecimal offset, int ... dateElements) {
        if (offset == null) {
            throw new CqlException("BigDecimal offset must be non-null");
        }
        if (dateElements.length == 0) {
            throw new InvalidDateTime("DateTime must include a year");
        }
        this.zoneOffset = this.toZoneOffset(offset);
        StringBuilder dateString = new StringBuilder();
        String[] stringElements = TemporalHelper.normalizeDateTimeElements(dateElements);
        for (int i = 0; i < stringElements.length; ++i) {
            if (i == 0) {
                dateString.append(stringElements[i]);
                continue;
            }
            if (i < 3) {
                dateString.append("-");
            } else if (i == 3) {
                dateString.append("T");
            } else if (i < 6) {
                dateString.append(":");
            } else if (i == 6) {
                dateString.append(".");
            }
            dateString.append(stringElements[i]);
        }
        this.precision = Precision.fromDateTimeIndex(stringElements.length - 1);
        dateString = new StringBuilder().append(TemporalHelper.autoCompleteDateTimeString(dateString.toString(), this.precision));
        dateString.append(this.zoneOffset.getId());
        this.setDateTime(OffsetDateTime.parse(dateString.toString()));
    }

    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }

    public DateTime expandPartialMinFromPrecision(Precision precision) {
        OffsetDateTime odt = this.getDateTime().plusYears(0L);
        for (int i = precision.toDateTimeIndex() + 1; i < 7; ++i) {
            odt = odt.with(Precision.fromDateTimeIndex(i).toChronoField(), odt.range(Precision.fromDateTimeIndex(i).toChronoField()).getMinimum());
        }
        return new DateTime(odt, this.precision);
    }

    public DateTime expandPartialMin(Precision precision) {
        OffsetDateTime odt = this.getDateTime().plusYears(0L);
        return new DateTime(odt, precision == null ? Precision.MILLISECOND : precision);
    }

    public DateTime expandPartialMax(Precision precision) {
        OffsetDateTime odt = this.getDateTime().plusYears(0L);
        for (int i = this.getPrecision().toDateTimeIndex() + 1; i < 7; ++i) {
            odt = i <= precision.toDateTimeIndex() ? odt.with(Precision.fromDateTimeIndex(i).toChronoField(), odt.range(Precision.fromDateTimeIndex(i).toChronoField()).getMaximum()) : odt.with(Precision.fromDateTimeIndex(i).toChronoField(), odt.range(Precision.fromDateTimeIndex(i).toChronoField()).getMinimum());
        }
        return new DateTime(odt, precision == null ? Precision.MILLISECOND : precision);
    }

    @Override
    public boolean isUncertain(Precision precision) {
        if (precision == Precision.WEEK) {
            precision = Precision.DAY;
        }
        return this.precision.toDateTimeIndex() < precision.toDateTimeIndex();
    }

    @Override
    public Interval getUncertaintyInterval(Precision precision) {
        DateTime start = this.expandPartialMin(precision);
        DateTime end = this.expandPartialMax(precision).expandPartialMinFromPrecision(precision);
        return new Interval(start, true, end, true);
    }

    @Override
    public Integer compare(BaseTemporal other, boolean forSort) {
        boolean differentPrecisions;
        boolean bl = differentPrecisions = this.getPrecision() != other.getPrecision();
        if (differentPrecisions) {
            Integer result = this.compareToPrecision(other, Precision.getHighestDateTimePrecision(this.precision, other.precision));
            if (result == null && forSort) {
                return this.precision.toDateTimeIndex() > other.precision.toDateTimeIndex() ? 1 : -1;
            }
            return result;
        }
        return this.compareToPrecision(other, this.precision);
    }

    public OffsetDateTime getNormalized(Precision precision) {
        return this.getNormalized(precision, this.zoneOffset);
    }

    public OffsetDateTime getNormalized(Precision precision, ZoneOffset nullableZoneOffset) {
        if (precision.toDateTimeIndex() > Precision.DAY.toDateTimeIndex()) {
            if (nullableZoneOffset != null) {
                return this.dateTime.withOffsetSameInstant(nullableZoneOffset);
            }
            throw new IllegalStateException("There must be a non-null offset!");
        }
        return this.dateTime;
    }

    @Override
    public Integer compareToPrecision(BaseTemporal other, Precision precision) {
        boolean leftMeetsPrecisionRequirements = this.precision.toDateTimeIndex() >= precision.toDateTimeIndex();
        boolean rightMeetsPrecisionRequirements = other.precision.toDateTimeIndex() >= precision.toDateTimeIndex();
        OffsetDateTime leftDateTime = this.getNormalized(precision);
        OffsetDateTime rightDateTime = ((DateTime)other).getNormalized(precision, this.getZoneOffset());
        if (!leftMeetsPrecisionRequirements || !rightMeetsPrecisionRequirements) {
            precision = Precision.getLowestDateTimePrecision(this.precision, other.precision);
        }
        for (int i = 0; i < precision.toDateTimeIndex() + 1; ++i) {
            int rightComp;
            int leftComp = leftDateTime.get(Precision.getDateTimeChronoFieldFromIndex(i));
            if (leftComp > (rightComp = rightDateTime.get(Precision.getDateTimeChronoFieldFromIndex(i)))) {
                return 1;
            }
            if (leftComp >= rightComp) continue;
            return -1;
        }
        if (leftMeetsPrecisionRequirements && rightMeetsPrecisionRequirements) {
            return 0;
        }
        return null;
    }

    @Override
    public int compareTo(BaseTemporal other) {
        return this.compare(other, true);
    }

    @Override
    public Boolean equivalent(Object other) {
        Integer comparison = this.compare((BaseTemporal)other, false);
        return comparison != null && comparison == 0;
    }

    @Override
    public Boolean equal(Object other) {
        Integer comparison = this.compare((BaseTemporal)other, false);
        return comparison == null ? null : Boolean.valueOf(comparison == 0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateTime otherDateTime = (DateTime)other;
        return Objects.equals(this.zoneOffset, otherDateTime.zoneOffset) && Objects.equals((Object)this.precision, (Object)otherDateTime.precision) && Objects.equals(this.dateTime, otherDateTime.dateTime);
    }

    public int hashCode() {
        return Objects.hash(this.zoneOffset, this.dateTime);
    }

    public String toString() {
        switch (this.precision) {
            case YEAR: {
                return String.format("%04d", this.dateTime.getYear());
            }
            case MONTH: {
                return String.format("%04d-%02d", this.dateTime.getYear(), this.dateTime.getMonthValue());
            }
            case DAY: {
                return String.format("%04d-%02d-%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth());
            }
            case HOUR: {
                return String.format("%04d-%02d-%02dT%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour());
            }
            case MINUTE: {
                return String.format("%04d-%02d-%02dT%02d:%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour(), this.dateTime.getMinute());
            }
            case SECOND: {
                return String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour(), this.dateTime.getMinute(), this.dateTime.getSecond());
            }
        }
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour(), this.dateTime.getMinute(), this.dateTime.getSecond(), this.dateTime.get(this.precision.toChronoField()));
    }

    public Date toJavaDate() {
        return Date.from(this.dateTime.toInstant());
    }

    public String toDateString() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTime);
    }

    private ZoneOffset toZoneOffset(OffsetDateTime offsetDateTime) {
        return offsetDateTime.getOffset();
    }

    private ZoneOffset toZoneOffset(BigDecimal offsetAsBigDecimal) {
        if (offsetAsBigDecimal == null) {
            return null;
        }
        return ZoneOffset.ofHoursMinutes(offsetAsBigDecimal.intValue(), new BigDecimal(60).multiply(offsetAsBigDecimal.remainder(BigDecimal.ONE)).intValue());
    }
}

