/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.exception.CqlException;

public class Libraries {
    private Libraries() {
    }

    public static IncludeDef resolveLibraryRef(String libraryName, Library relativeTo) {
        for (IncludeDef includeDef : relativeTo.getIncludes().getDef()) {
            if (!includeDef.getLocalIdentifier().equals(libraryName)) continue;
            return includeDef;
        }
        throw new CqlException(String.format("Could not resolve library reference '%s'.", libraryName));
    }

    public static List<ExpressionDef> resolveAllExpressionRef(String name, Library relativeTo) {
        int first;
        List defs = relativeTo.getStatements().getDef();
        int index = Collections.binarySearch(defs, name, (x, k) -> ((ExpressionDef)x).getName().compareTo((String)k));
        if (index == -1) {
            return Collections.emptyList();
        }
        int last = index + 1;
        for (first = index; first > 0 && ((ExpressionDef)defs.get(first - 1)).getName().equals(name); --first) {
        }
        while (last < defs.size() && ((ExpressionDef)defs.get(last)).getName().equals(name)) {
            ++last;
        }
        return defs.subList(first, last);
    }

    public static ExpressionDef resolveExpressionRef(String name, Library relativeTo) {
        int result = Collections.binarySearch(relativeTo.getStatements().getDef(), name, (x, k) -> ((ExpressionDef)x).getName().compareTo((String)k));
        if (result >= 0) {
            return (ExpressionDef)relativeTo.getStatements().getDef().get(result);
        }
        throw new CqlException(String.format("Could not resolve expression reference '%s' in library '%s'.", name, relativeTo.getIdentifier().getId()));
    }

    public static CodeSystemDef resolveCodeSystemRef(String name, Library relativeTo) {
        for (CodeSystemDef codeSystemDef : relativeTo.getCodeSystems().getDef()) {
            if (!codeSystemDef.getName().equals(name)) continue;
            return codeSystemDef;
        }
        throw new CqlException(String.format("Could not resolve code system reference '%s' in library '%s'.", name, relativeTo.getIdentifier().getId()));
    }

    public static ValueSetDef resolveValueSetRef(String name, Library relativeTo) {
        for (ValueSetDef valueSetDef : relativeTo.getValueSets().getDef()) {
            if (!valueSetDef.getName().equals(name)) continue;
            return valueSetDef;
        }
        throw new CqlException(String.format("Could not resolve value set reference '%s' in library '%s'.", name, relativeTo.getIdentifier().getId()));
    }

    public static CodeDef resolveCodeRef(String name, Library relativeTo) {
        for (CodeDef codeDef : relativeTo.getCodes().getDef()) {
            if (!codeDef.getName().equals(name)) continue;
            return codeDef;
        }
        throw new CqlException(String.format("Could not resolve code reference '%s' in library '%s'.", name, relativeTo.getIdentifier().getId()));
    }

    public static ParameterDef resolveParameterRef(String name, Library relativeTo) {
        for (ParameterDef parameterDef : relativeTo.getParameters().getDef()) {
            if (!parameterDef.getName().equals(name)) continue;
            return parameterDef;
        }
        throw new CqlException(String.format("Could not resolve parameter reference '%s' in library '%s'.", name, relativeTo.getIdentifier().getId()));
    }

    public static ConceptDef resolveConceptRef(String name, Library relativeTo) {
        for (ConceptDef conceptDef : relativeTo.getConcepts().getDef()) {
            if (!conceptDef.getName().equals(name)) continue;
            return conceptDef;
        }
        throw new CqlException(String.format("Could not resolve concept reference '%s'.", name));
    }

    public static List<FunctionDef> getFunctionDefs(String name, Library relativeTo) {
        List<ExpressionDef> defs = Libraries.resolveAllExpressionRef(name, relativeTo);
        return defs.stream().filter(FunctionDef.class::isInstance).map(FunctionDef.class::cast).collect(Collectors.toList());
    }

    public static VersionedIdentifier toVersionedIdentifier(IncludeDef includeDef) {
        return new VersionedIdentifier().withSystem(NamespaceManager.getUriPart((String)includeDef.getPath())).withId(NamespaceManager.getNamePart((String)includeDef.getPath())).withVersion(includeDef.getVersion());
    }
}

