/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.Iterator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;

public class MaxEvaluator {
    public static Object max(Object source, State state) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Iterable element = (Iterable)source;
            Iterator itr = element.iterator();
            if (!itr.hasNext()) {
                return null;
            }
            Object max = itr.next();
            while (max == null && itr.hasNext()) {
                max = itr.next();
            }
            while (itr.hasNext()) {
                Boolean greater;
                Object value = itr.next();
                if (value == null || (greater = GreaterEvaluator.greater(value, max, state)) == null || !greater.booleanValue()) continue;
                max = value;
            }
            return max;
        }
        throw new InvalidOperatorArgument("Max(List<Integer>), Max(List<Long>, Max(List<Decimal>, Max(List<Quantity>), Max(List<Date>), Max(List<DateTime>), Max(List<Time>) or Max(List<String>))", String.format("Max(%s)", source.getClass().getName()));
    }
}

