/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Value;

public class LogEvaluator {
    public static Object log(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof BigDecimal) {
            double base = ((BigDecimal)right).doubleValue();
            double argument = ((BigDecimal)left).doubleValue();
            if (base == 1.0) {
                return null;
            }
            return Value.verifyPrecision(BigDecimal.valueOf(Math.log(argument) / Math.log(base)), null);
        }
        throw new InvalidOperatorArgument("Log(Decimal, Decimal)", String.format("Log(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

