/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.Arrays;
import org.opencds.cqf.cql.engine.elm.executing.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.InEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class IncludedInEvaluator {
    public static Boolean includedIn(Object left, Object right, String precision, State state) {
        if (left instanceof Interval && right instanceof Interval) {
            return IncludedInEvaluator.intervalIncludedIn((Interval)left, (Interval)right, precision, state);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return IncludedInEvaluator.listIncludedIn((Iterable)left, (Iterable)right, state);
        }
        throw new InvalidOperatorArgument("IncludedIn(Interval<T>, Interval<T>), IncludedIn(List<T>, List<T>) or IncludedIn(T, List<T>)", String.format("IncludedIn(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean intervalIncludedIn(Interval left, Interval right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        Object leftStart = left.getStart();
        Object leftEnd = left.getEnd();
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        Boolean boundaryCheck = AndEvaluator.and(InEvaluator.in(leftStart, right, precision, state), InEvaluator.in(leftEnd, right, precision, state));
        if (boundaryCheck != null && boundaryCheck.booleanValue()) {
            return true;
        }
        if (leftStart instanceof BaseTemporal || leftEnd instanceof BaseTemporal || rightStart instanceof BaseTemporal || rightEnd instanceof BaseTemporal) {
            if (AnyTrueEvaluator.anyTrue(Arrays.asList(BeforeEvaluator.before(leftStart, rightStart, precision, state), AfterEvaluator.after(leftEnd, rightEnd, precision, state))).booleanValue()) {
                return false;
            }
            return AndEvaluator.and(SameOrAfterEvaluator.sameOrAfter(leftStart, rightStart, precision, state), SameOrBeforeEvaluator.sameOrBefore(leftEnd, rightEnd, precision, state));
        }
        if (AnyTrueEvaluator.anyTrue(Arrays.asList(LessEvaluator.less(leftStart, rightStart, state), GreaterEvaluator.greater(leftEnd, rightEnd, state))).booleanValue()) {
            return false;
        }
        return AndEvaluator.and(GreaterOrEqualEvaluator.greaterOrEqual(leftStart, rightStart, state), LessOrEqualEvaluator.lessOrEqual(leftEnd, rightEnd, state));
    }

    public static Boolean listIncludedIn(Iterable<?> left, Iterable<?> right, State state) {
        if (right == null) {
            return false;
        }
        if (left == null) {
            return InEvaluator.in(null, right, null, state);
        }
        for (Object element : left) {
            Boolean in = InEvaluator.in(element, right, null, state);
            if (in == null || in.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Object internalEvaluate(Object left, Object right, String precision, State state) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right instanceof Interval ? IncludedInEvaluator.intervalIncludedIn(null, (Interval)right, precision, state) : IncludedInEvaluator.listIncludedIn(null, (Iterable)right, state);
        }
        if (right == null) {
            return left instanceof Interval ? IncludedInEvaluator.intervalIncludedIn((Interval)left, null, precision, state) : IncludedInEvaluator.listIncludedIn((Iterable)left, null, state);
        }
        return IncludedInEvaluator.includedIn(left, right, precision, state);
    }
}

