/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.Arrays;
import org.opencds.cqf.cql.engine.elm.executing.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class InEvaluator {
    public static Boolean in(Object left, Object right, String precision, State state) {
        if (right == null) {
            return false;
        }
        if (right instanceof Iterable) {
            return InEvaluator.listIn(left, (Iterable)right, state);
        }
        if (right instanceof Interval) {
            return InEvaluator.intervalIn(left, (Interval)right, precision, state);
        }
        throw new InvalidOperatorArgument("In(T, Interval<T>) or In(T, List<T>)", String.format("In(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    private static Boolean intervalIn(Object left, Interval right, String precision, State state) {
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        if (left instanceof BaseTemporal) {
            if (AnyTrueEvaluator.anyTrue(Arrays.asList(SameAsEvaluator.sameAs(left, right.getStart(), precision, state), SameAsEvaluator.sameAs(left, right.getEnd(), precision, state))).booleanValue()) {
                return true;
            }
            if (AnyTrueEvaluator.anyTrue(Arrays.asList(BeforeEvaluator.before(left, right.getStart(), precision, state), AfterEvaluator.after(left, right.getEnd(), precision, state))).booleanValue()) {
                return false;
            }
            Boolean pointSameOrAfterStart = rightStart == null && right.getLowClosed() ? Boolean.valueOf(true) : SameOrAfterEvaluator.sameOrAfter(left, rightStart, precision, state);
            Boolean pointSameOrBeforeEnd = rightEnd == null && right.getHighClosed() ? Boolean.valueOf(true) : SameOrBeforeEvaluator.sameOrBefore(left, rightEnd, precision, state);
            return AndEvaluator.and(pointSameOrAfterStart, pointSameOrBeforeEnd);
        }
        if (AnyTrueEvaluator.anyTrue(Arrays.asList(EqualEvaluator.equal(left, right.getStart(), state), EqualEvaluator.equal(left, right.getEnd(), state))).booleanValue()) {
            return true;
        }
        if (AnyTrueEvaluator.anyTrue(Arrays.asList(LessEvaluator.less(left, right.getStart(), state), GreaterEvaluator.greater(left, right.getEnd(), state))).booleanValue()) {
            return false;
        }
        Boolean greaterOrEqual = rightStart == null && right.getLowClosed() ? Boolean.valueOf(true) : GreaterOrEqualEvaluator.greaterOrEqual(left, rightStart, state);
        Boolean lessOrEqual = rightEnd == null && right.getHighClosed() ? Boolean.valueOf(true) : LessOrEqualEvaluator.lessOrEqual(left, rightEnd, state);
        return AndEvaluator.and(greaterOrEqual, lessOrEqual);
    }

    private static Boolean listIn(Object left, Iterable<?> right, State state) {
        for (Object element : right) {
            if (element == null && left == null) {
                return true;
            }
            Boolean isEqual = EqualEvaluator.equal(left, element, state);
            if (isEqual == null || !isEqual.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Object internalEvaluate(Object left, Object right, String precision, State state) {
        return InEvaluator.in(left, right, precision, state);
    }
}

