/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.UcumService;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class ConvertQuantityEvaluator {
    public static Object convertQuantity(Object argument, Object unit, UcumService ucumService) {
        if (argument == null || unit == null) {
            return null;
        }
        if (argument instanceof Quantity) {
            if (ucumService == null) {
                return null;
            }
            try {
                Decimal result = ucumService.convert(new Decimal(String.valueOf(((Quantity)argument).getValue())), ((Quantity)argument).getUnit(), (String)unit);
                return new Quantity().withValue(new BigDecimal(result.asDecimal())).withUnit((String)unit);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new InvalidOperatorArgument("ConvertQuantity(Quantity, String)", String.format("ConvertQuantity(%s, %s)", argument.getClass().getName(), unit.getClass().getName()));
    }
}

