/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.elm.executing.AddEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DivideEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class AvgEvaluator {
    public static Object avg(Object source, State state) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Iterable elements = (Iterable)source;
            Object avg = null;
            int size = 1;
            for (Object element : elements) {
                if (element == null) continue;
                if (element instanceof BigDecimal || element instanceof Quantity) {
                    if (avg == null) {
                        avg = element;
                        continue;
                    }
                    ++size;
                    avg = AddEvaluator.add(avg, element);
                    continue;
                }
                throw new InvalidOperatorArgument("Avg(List<Decimal>), Avg(List<Quantity>)", String.format("Avg(List<%s>)", source.getClass().getName()));
            }
            return DivideEvaluator.divide(avg, new BigDecimal(size), state);
        }
        throw new InvalidOperatorArgument("Avg(List<Decimal>), Avg(List<Quantity>)", String.format("Avg(%s)", source.getClass().getName()));
    }
}

