/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.elm.r1.Element;
import org.opencds.cqf.cql.engine.debug.DebugLocator;
import org.opencds.cqf.cql.engine.debug.DebugResultEntry;
import org.opencds.cqf.cql.engine.debug.Location;

public class DebugLibraryResultEntry {
    private String libraryName;
    private Map<DebugLocator, List<DebugResultEntry>> results;

    public String getLibraryName() {
        return this.libraryName;
    }

    public DebugLibraryResultEntry(String libraryName) {
        this.libraryName = libraryName;
        this.results = new HashMap<DebugLocator, List<DebugResultEntry>>();
    }

    public Map<DebugLocator, List<DebugResultEntry>> getResults() {
        return this.results;
    }

    private void logDebugResult(DebugLocator locator, Object result) {
        if (!this.results.containsKey(locator)) {
            this.results.put(locator, new ArrayList());
        }
        List<DebugResultEntry> debugResults = this.results.get(locator);
        debugResults.add(new DebugResultEntry(result));
    }

    public void logDebugResultEntry(Element node, Object result) {
        if (node instanceof Element) {
            DebugLocator locator;
            Element element = node;
            if (element.getLocalId() != null) {
                locator = new DebugLocator(DebugLocator.DebugLocatorType.NODE_ID, element.getLocalId());
                this.logDebugResult(locator, result);
            }
            if (element.getLocator() != null) {
                locator = new DebugLocator(Location.fromLocator(element.getLocator()));
                this.logDebugResult(locator, result);
            }
        } else {
            DebugLocator locator = new DebugLocator(DebugLocator.DebugLocatorType.NODE_TYPE, node.getClass().getSimpleName());
            this.logDebugResult(locator, result);
        }
    }
}

