package com.payu.paymentparamhelper.siparams;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.paymentparamhelper.siparams.enums.BeneficiaryAccountType;

public class BeneficiaryDetails implements Parcelable {
    private String beneficiaryName;
    private String beneficiaryAccountNumber;
    private String beneficiaryIfsc;
    private String verificationMode;
    private BeneficiaryAccountType beneficiaryAccountType;

    public BeneficiaryDetails() {
    }



    public BeneficiaryDetails(String beneficiaryName, String beneficiaryAccountNumber, String beneficiaryIfsc, BeneficiaryAccountType accountType) {
        this.beneficiaryName = beneficiaryName;
        this.beneficiaryAccountNumber = beneficiaryAccountNumber;
        this.beneficiaryIfsc = beneficiaryIfsc;
        this.beneficiaryAccountType = accountType;
    }

    protected BeneficiaryDetails(Parcel in) {
        beneficiaryName = in.readString();
        beneficiaryAccountNumber = in.readString();
        beneficiaryIfsc = in.readString();
        beneficiaryAccountType = BeneficiaryAccountType.valueOf(in.readString());
        verificationMode = in.readString();
    }

    public static final Creator<BeneficiaryDetails> CREATOR = new Creator<BeneficiaryDetails>() {
        @Override
        public BeneficiaryDetails createFromParcel(Parcel in) {
            return new BeneficiaryDetails(in);
        }

        @Override
        public BeneficiaryDetails[] newArray(int size) {
            return new BeneficiaryDetails[size];
        }
    };

    public String getBeneficiaryName() {
        return beneficiaryName;
    }

    public void setBeneficiaryName(String beneficiaryName) {
        this.beneficiaryName = beneficiaryName;
    }

    public String getBeneficiaryAccountNumber() {
        return beneficiaryAccountNumber;
    }

    public void setBeneficiaryAccountNumber(String beneficiaryAccountNumber) {
        this.beneficiaryAccountNumber = beneficiaryAccountNumber;
    }

    public String getBeneficiaryIfsc() {
        return beneficiaryIfsc;
    }

    public void setBeneficiaryIfsc(String beneficiaryIfsc) {
        this.beneficiaryIfsc = beneficiaryIfsc;
    }
    public String getVerificationMode() {
        return verificationMode;
    }

    public void setVerificationMode(String verificationMode) {
        this.verificationMode = verificationMode;
    }
    public BeneficiaryAccountType getBeneficiaryAccountType() {
        return beneficiaryAccountType;
    }

    public void setBeneficiaryAccountType(BeneficiaryAccountType beneficiaryAccountType) {
        this.beneficiaryAccountType = beneficiaryAccountType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(beneficiaryName);
        dest.writeString(beneficiaryAccountNumber);
        dest.writeString(beneficiaryIfsc);
        dest.writeString(this.beneficiaryAccountType.name());
        dest.writeString(verificationMode);
    }
}
