/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.twoline;

import in.kncsolutions.dhelm.candlebasic.ClosingWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.FourPriceDoji;
import in.kncsolutions.dhelm.candlebasic.LongWhiteCandle;
import in.kncsolutions.dhelm.candlebasic.OpeningWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.WhiteCandle;
import in.kncsolutions.dhelm.candlebasic.WhiteMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class BearishHarami {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isBearishHarami;

    public BearishHarami(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numBody, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefBody = numBody;
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isBearishHarami = false;
        if (this.Open.size() < (this.RefTrend + 2 > this.RefLength ? this.RefTrend + 2 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BearishHarami();
    }

    private void BearishHarami() throws DataException {
        if (this.Close.get(0) <= this.Open.get(0) && !new FourPriceDoji(this.Open, this.High, this.Low, this.Close).isFourPriceDoji() && this.Close.get(1) > this.Open.get(1) && this.validBasicCandle() && this.Close.get(0) > this.Open.get(1) && this.Open.get(0) < this.Close.get(1)) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(2, this.RefTrend + 2), (int)this.Close.subList(2, this.RefTrend + 2).size());
            if (this.trendPrior[0] < 0.0) {
                this.isBearishHarami = true;
            }
        }
    }

    private boolean validBasicCandle() throws DataException {
        return new WhiteCandle(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size()), this.RefBody, this.RefLength, this.Percentage).isWhiteCandle() || new LongWhiteCandle(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size()), this.RefBody, this.RefLength, this.Percentage).isLongWhiteCandle() || new WhiteMarubozu(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size())).isLongWhiteMarubozu(this.RefLength, this.Percentage) || new ClosingWhiteMarubozu(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size())).isLongClosingWhiteMarubozu(this.RefLength, this.Percentage) || new OpeningWhiteMarubozu(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size())).isLongOpeningWhiteMarubozu(this.RefLength, this.Percentage);
    }

    public boolean isBearishHarami() {
        return this.isBearishHarami;
    }
}

