/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.oneline;

import in.kncsolutions.dhelm.candlebasic.ClosingWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.LongWhiteCandle;
import in.kncsolutions.dhelm.candlebasic.OpeningWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.WhiteMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import java.util.ArrayList;
import java.util.List;

public class BullishStrongLine {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private double Percentage;
    private boolean isBullishStrongLine;

    public BullishStrongLine(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numBody, int numLen, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numBody;
        this.RefLength = numLen;
        this.Percentage = percentage;
        this.isBullishStrongLine = false;
        if (this.Open.size() < (this.RefBody > this.RefLength ? this.RefBody : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BullishStrongLine();
    }

    private void BullishStrongLine() throws DataException {
        double avgBodyLength = CandleFacts.getAverageLength(this.Open, this.Close, (int)this.RefBody);
        if ((new OpeningWhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongOpeningWhiteMarubozu(this.RefLength, this.Percentage) || new ClosingWhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongClosingWhiteMarubozu(this.RefLength, this.Percentage) || new WhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongWhiteMarubozu(this.RefLength, this.Percentage) || new LongWhiteCandle(this.Open, this.High, this.Low, this.Close, this.RefBody, this.RefLength, this.Percentage).isLongWhiteCandle()) && this.Close.get(0) - this.Open.get(0) >= 3.0 * avgBodyLength) {
            this.isBullishStrongLine = true;
        }
    }

    public boolean isBullishStrongLine() {
        return this.isBullishStrongLine;
    }
}

