/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.oneline;

import in.kncsolutions.dhelm.candlebasic.OpeningBlackMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class BearishBeltHold {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private int RefTrend;
    private double Percentage1;
    private double Percentage2;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isBearishBeltHold;

    public BearishBeltHold(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, int numTrend, double p1, double p2) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage1 = p1;
        this.Percentage2 = p2;
        this.isBearishBeltHold = false;
        if (this.Open.size() < this.RefLength || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BearishBeltHold();
    }

    private void BearishBeltHold() throws DataException {
        if (new OpeningBlackMarubozu(this.Open, this.High, this.Low, this.Close).isLongOpeningBlackMarubozu(this.RefLength, this.Percentage1) && (this.Close.get(0) - this.Low.get(0)) / (this.Open.get(0) - this.Close.get(0)) <= this.Percentage2 / 100.0) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(1, this.RefTrend + 1), (int)this.Close.subList(1, this.RefTrend + 1).size());
            if (this.trendPrior[0] < 0.0) {
                this.isBearishBeltHold = true;
            }
        }
    }

    public boolean isBearishBeltHold() {
        return this.isBearishBeltHold;
    }
}

