/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.multiline;

import in.kncsolutions.dhelm.candlepattern.twoline.BearishHarami;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class ThreeInsideDown {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isThreeInsideDown;

    public ThreeInsideDown(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numBody, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefBody = numBody;
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isThreeInsideDown = false;
        if (this.Open.size() < (this.RefTrend + 3 > this.RefLength ? this.RefTrend + 3 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.ThreeInsideDown();
    }

    private void ThreeInsideDown() throws DataException {
        if (this.Close.get(0) < this.Open.get(0) && this.validCandlePattern() && this.Close.get(0) < this.Close.get(1)) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(3, this.RefTrend + 2), (int)this.Close.subList(3, this.RefTrend + 2).size());
            if (this.trendPrior[0] < 0.0) {
                this.isThreeInsideDown = true;
            }
        }
    }

    private boolean validCandlePattern() throws DataException {
        return new BearishHarami(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size()), this.RefBody, this.RefLength, this.RefTrend, this.Percentage).isBearishHarami();
    }

    public boolean isThreeInsideDown() {
        return this.isThreeInsideDown;
    }
}

