/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceReplacer
extends XMLFilterImpl {
    protected Map<String, String> old2new = new HashMap<String, String>();
    protected Map<String, String> new2old = new HashMap<String, String>();
    private static Properties SUGGESTED = new Properties();
    protected final MyNamespaceSupport oldNSSupport;
    protected final MyNamespaceSupport newNSSupport;
    private AttributeReplacer attributeReplacer = new AttributeReplacer();
    private Attribute2Replacer attribute2Replacer = new Attribute2Replacer();

    public NamespaceReplacer(Map<String, String> old2new) {
        this.old2new = old2new;
        for (Map.Entry<String, String> entry : old2new.entrySet()) {
            this.new2old.put(entry.getValue(), entry.getKey());
        }
        if (old2new.containsKey("") || this.new2old.containsKey("")) {
            this.oldNSSupport = new MyNamespaceSupport(SUGGESTED);
            this.newNSSupport = new MyNamespaceSupport(SUGGESTED);
        } else {
            this.newNSSupport = null;
            this.oldNSSupport = null;
        }
    }

    public NamespaceReplacer(XMLReader xmlReader, Map<String, String> old2new) {
        this(old2new);
        this.setParent(xmlReader);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name) && value) {
            throw new SAXNotSupportedException("Feature 'http://xml.org/sax/features/namespace-prefixes' is not supported");
        }
        if ("http://xml.org/sax/features/namespaces".equals(name) && !value) {
            throw new SAXNotSupportedException("Feature 'http://xml.org/sax/features/namespaces' is required");
        }
        super.setFeature(name, value);
    }

    protected String translate(String namespace, Map<String, String> map) {
        String value = map.get(namespace);
        return value == null ? namespace : value;
    }

    protected String translateAttribute(String namespace, Map<String, String> map) {
        return namespace.isEmpty() ? namespace : this.translate(namespace, map);
    }

    private Attributes replace(Attributes attrs) {
        if (attrs instanceof Attributes2) {
            this.attribute2Replacer.setDelegate((Attributes2)attrs);
            return this.attribute2Replacer;
        }
        this.attributeReplacer.setDelegate(attrs);
        return this.attributeReplacer;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.oldNSSupport != null) {
            this.oldNSSupport.startDocument();
            this.newNSSupport.startDocument();
        }
        super.startDocument();
        String uri = this.translate("", this.old2new);
        if (uri != null) {
            this.startPrefixMapping("", "");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.oldNSSupport != null) {
            this.oldNSSupport.startPrefixMapping(prefix, uri);
        }
        uri = this.translate(uri, this.old2new);
        if (this.newNSSupport != null) {
            this.newNSSupport.setSuggestPrefix(prefix.isEmpty() ? "ns" : prefix);
            prefix = this.newNSSupport.declarePrefix(uri);
        }
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.oldNSSupport != null) {
            this.oldNSSupport.startElement();
            this.newNSSupport.startElement();
        }
        uri = this.translate(uri, this.old2new);
        if (this.newNSSupport != null) {
            qName = this.newNSSupport.toQName(uri, localName);
        }
        super.startElement(uri, localName, qName, this.replace(atts));
    }

    protected String translateAttribute(String qName, MyNamespaceSupport from, MyNamespaceSupport to) {
        if (from == null) {
            return qName;
        }
        int colon = qName.indexOf(58);
        if (colon == -1) {
            return qName;
        }
        String prefix = qName.substring(0, colon);
        String localName = qName.substring(colon + 1);
        String uri = from.findURI(prefix);
        return to.toQName(uri, localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        uri = this.translate(uri, this.old2new);
        if (this.newNSSupport != null) {
            qName = this.newNSSupport.toQName(uri, localName);
        }
        super.endElement(uri, localName, qName);
        if (this.oldNSSupport != null) {
            this.oldNSSupport.endElement();
            assert (this.newNSSupport != null);
            this.newNSSupport.endElement();
        }
    }

    private class Attribute2Replacer
    extends AttributeReplacer
    implements Attributes2 {
        protected Attributes2 delegate;

        private Attribute2Replacer() {
        }

        public void setDelegate(Attributes2 delegate) {
            super.setDelegate(delegate);
            this.delegate = delegate;
        }

        @Override
        public boolean isDeclared(int index) {
            return this.delegate.isDeclared(index);
        }

        @Override
        public boolean isDeclared(String qName) {
            return this.delegate.isDeclared(qName);
        }

        @Override
        public boolean isDeclared(String uri, String localName) {
            return this.delegate.isDeclared(NamespaceReplacer.this.translateAttribute(uri, NamespaceReplacer.this.new2old), localName);
        }

        @Override
        public boolean isSpecified(int index) {
            return this.delegate.isSpecified(index);
        }

        @Override
        public boolean isSpecified(String uri, String localName) {
            return this.delegate.isSpecified(NamespaceReplacer.this.translateAttribute(uri, NamespaceReplacer.this.new2old), localName);
        }

        @Override
        public boolean isSpecified(String qName) {
            return this.delegate.isSpecified(NamespaceReplacer.this.translateAttribute(qName, NamespaceReplacer.this.newNSSupport, NamespaceReplacer.this.oldNSSupport));
        }
    }

    private class AttributeReplacer
    implements Attributes {
        protected Attributes delegate;

        private AttributeReplacer() {
        }

        public void setDelegate(Attributes delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getLength() {
            return this.delegate.getLength();
        }

        @Override
        public String getURI(int index) {
            return NamespaceReplacer.this.translateAttribute(this.delegate.getURI(index), NamespaceReplacer.this.old2new);
        }

        @Override
        public String getLocalName(int index) {
            return this.delegate.getLocalName(index);
        }

        @Override
        public String getQName(int index) {
            return NamespaceReplacer.this.translateAttribute(this.delegate.getQName(index), NamespaceReplacer.this.oldNSSupport, NamespaceReplacer.this.newNSSupport);
        }

        @Override
        public String getType(int index) {
            return this.delegate.getType(index);
        }

        @Override
        public String getValue(int index) {
            return this.delegate.getValue(index);
        }

        @Override
        public int getIndex(String uri, String localName) {
            return this.delegate.getIndex(NamespaceReplacer.this.translateAttribute(uri, NamespaceReplacer.this.new2old), localName);
        }

        @Override
        public int getIndex(String qName) {
            return this.delegate.getIndex(NamespaceReplacer.this.translateAttribute(qName, NamespaceReplacer.this.newNSSupport, NamespaceReplacer.this.oldNSSupport));
        }

        @Override
        public String getType(String uri, String localName) {
            return this.delegate.getType(NamespaceReplacer.this.translateAttribute(uri, NamespaceReplacer.this.new2old), localName);
        }

        @Override
        public String getType(String qName) {
            return this.delegate.getType(qName);
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.delegate.getValue(NamespaceReplacer.this.translateAttribute(uri, NamespaceReplacer.this.new2old), localName);
        }

        @Override
        public String getValue(String qName) {
            return this.delegate.getValue(NamespaceReplacer.this.translateAttribute(qName, NamespaceReplacer.this.newNSSupport, NamespaceReplacer.this.oldNSSupport));
        }
    }
}

