/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import jlibs.core.net.URLUtil;
import jlibs.xml.Namespaces;

public class DefaultNamespaceContext
implements NamespaceContext {
    private Properties suggested;
    private Map<String, String> prefix2uriMap = new HashMap<String, String>();
    private Map<String, String> uri2prefixMap = new HashMap<String, String>();
    private String defaultURI = "";

    public DefaultNamespaceContext() {
        this(Namespaces.getSuggested());
    }

    public DefaultNamespaceContext(Properties suggested) {
        this.suggested = suggested;
        this.declarePrefix("", "");
        this.declarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        this.declarePrefix("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if (prefix.length() == 0) {
            return this.defaultURI;
        }
        return this.prefix2uriMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI is null");
        }
        if (this.defaultURI.equals(namespaceURI)) {
            return "";
        }
        return this.uri2prefixMap.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        ArrayList<String> list = new ArrayList<String>(this.prefix2uriMap.size());
        for (Map.Entry<String, String> entry : this.prefix2uriMap.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    public void declarePrefix(String prefix, String uri) {
        if (prefix.length() == 0) {
            this.defaultURI = uri;
        }
        this.prefix2uriMap.put(prefix, uri);
        this.uri2prefixMap.put(uri, prefix);
    }

    public String declarePrefix(String uri) {
        String prefix = this.getPrefix(uri);
        if (prefix == null) {
            prefix = URLUtil.suggestPrefix((Properties)this.suggested, (String)uri);
            if (this.getNamespaceURI(prefix) != null) {
                int i = 1;
                while (true) {
                    String _prefix;
                    if (this.getNamespaceURI(_prefix = prefix + i) == null) {
                        prefix = _prefix;
                        break;
                    }
                    ++i;
                }
            }
            this.declarePrefix(prefix, uri);
        }
        return prefix;
    }

    public QName toQName(String qname) {
        String ns;
        String prefix = "";
        String localName = qname;
        int colon = qname.indexOf(58);
        if (colon != -1) {
            prefix = qname.substring(0, colon);
            localName = qname.substring(colon + 1);
        }
        if ((ns = this.getNamespaceURI(prefix)) == null) {
            throw new IllegalArgumentException("undeclared prefix: " + prefix);
        }
        return new QName(ns, localName, prefix);
    }
}

