/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class InputStreamChannel
implements ReadableByteChannel {
    private InputStream is;
    private boolean eof;

    public InputStreamChannel(InputStream is) {
        this.is = is;
    }

    public boolean isEOF() {
        return this.eof;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        int pos = buffer.position();
        int read = this.is.read(buffer.array(), buffer.arrayOffset() + pos, buffer.remaining());
        if (read > 0) {
            buffer.position(pos + read);
        } else if (read == -1) {
            this.eof = true;
        }
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.is != null;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.is = null;
    }
}

