/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Noun {
    private static List<Replacer> plurals = new LinkedList<Replacer>();
    private static List<Replacer> singulars = new ArrayList<Replacer>();
    private static List<String> uncountables = new LinkedList<String>();

    public static void addPlural(String match, String rule) {
        Noun.addPlural(match, rule, true);
    }

    public static void addPlural(String match, String rule, boolean insensitive) {
        plurals.add(0, new Replacer(match, rule, insensitive));
    }

    public static void addSingular(String match, String rule) {
        Noun.addSingular(match, rule, true);
    }

    public static void addSingular(String match, String rule, boolean insensitive) {
        singulars.add(0, new Replacer(match, rule, insensitive));
    }

    public static void addIrregular(String singular, String plural) {
        Noun.addPlural("(.*)(" + singular.substring(0, 1) + ")" + singular.substring(1) + "$", "\\1\\2" + plural.substring(1));
        Noun.addSingular("(.*)(" + plural.substring(0, 1) + ")" + plural.substring(1) + "$", "\\1\\2" + singular.substring(1));
    }

    public static void addUncountable(String word) {
        uncountables.add(0, word.toLowerCase());
    }

    private static String translate(String word, List<Replacer> replacers) {
        for (String uncountable : uncountables) {
            if (!uncountable.equals(word)) continue;
            return word;
        }
        for (Replacer replacer : replacers) {
            Matcher matcher = replacer.pattern.matcher(word);
            if (!matcher.matches()) continue;
            StringBuffer sb = new StringBuffer();
            boolean group = false;
            for (int i = 0; i < replacer.rule.length(); ++i) {
                char ch = replacer.rule.charAt(i);
                if (group) {
                    sb.append(matcher.group(Character.digit(ch, 10)));
                    group = false;
                    continue;
                }
                if (ch == '\\') {
                    group = true;
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return word;
    }

    public static String pluralize(String word) {
        return Noun.translate(word, plurals);
    }

    public static String singularize(String word) {
        return Noun.translate(word, singulars);
    }

    static {
        Noun.addPlural("$", "s", false);
        Noun.addPlural("(.*)$", "\\1s");
        Noun.addPlural("(.*)(ax|test)is$", "\\1\\2es");
        Noun.addPlural("(.*)(octop|vir)us$", "\\1\\2i");
        Noun.addPlural("(.*)(alias|status)$", "\\1\\2es");
        Noun.addPlural("(.*)(bu)s$", "\\1\\2ses");
        Noun.addPlural("(.*)(buffal|tomat)o$", "\\1\\2oes");
        Noun.addPlural("(.*)([ti])um$", "\\1\\2a");
        Noun.addPlural("(.*)sis$", "\\1ses");
        Noun.addPlural("(.*)(?:([^f])fe|([lr])f)$", "\\1\\3ves");
        Noun.addPlural("(.*)(hive)$", "\\1\\2s");
        Noun.addPlural("(.*)(tive)$", "\\1\\2s");
        Noun.addPlural("(.*)([^aeiouy]|qu)y$", "\\1\\2ies");
        Noun.addPlural("(.*)(series)$", "\\1\\2");
        Noun.addPlural("(.*)(movie)$", "\\1\\2s");
        Noun.addPlural("(.*)(x|ch|ss|sh)$", "\\1\\2es");
        Noun.addPlural("(.*)(matr|vert|ind)ix|ex$", "\\1\\2ices");
        Noun.addPlural("(.*)(o)$", "\\1\\2es");
        Noun.addPlural("(.*)(shoe)$", "\\1\\2s");
        Noun.addPlural("(.*)([m|l])ouse$", "\\1\\2ice");
        Noun.addPlural("^(ox)$", "\\1en");
        Noun.addPlural("(.*)(vert|ind)ex$", "\\1\\2ices");
        Noun.addPlural("(.*)(matr)ix$", "\\1\\2ices");
        Noun.addPlural("(.*)(quiz)$", "\\1\\2zes");
        Noun.addSingular("(.*)s$", "\\1");
        Noun.addSingular("(.*)(n)ews$", "\\1\\2ews");
        Noun.addSingular("(.*)([ti])a$", "\\1\\2um");
        Noun.addSingular("(.*)((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "\\1\\2sis");
        Noun.addSingular("(.*)(^analy)ses$", "\\1\\2sis");
        Noun.addSingular("(.*)([^f])ves$", "\\1\\2fe");
        Noun.addSingular("(.*)(hive)s$", "\\1\\2");
        Noun.addSingular("(.*)(tive)s$", "\\1\\2");
        Noun.addSingular("(.*)([lr])ves$", "\\1\\2f");
        Noun.addSingular("(.*)([^aeiouy]|qu)ies$", "\\1\\2y");
        Noun.addSingular("(.*)(s)eries$", "\\1\\2eries");
        Noun.addSingular("(.*)(m)ovies$", "\\1\\2ovie");
        Noun.addSingular("(.*)(x|ch|ss|sh)es$", "\\1\\2");
        Noun.addSingular("(.*)([m|l])ice$", "\\1\\2ouse");
        Noun.addSingular("(.*)(bus)es$", "\\1\\2");
        Noun.addSingular("(.*)(o)es$", "\\1\\2");
        Noun.addSingular("(.*)(shoe)s$", "\\1\\2");
        Noun.addSingular("(.*)(cris|ax|test)es$", "\\1\\2is");
        Noun.addSingular("(.*)(octop|vir)i$", "\\1\\2us");
        Noun.addSingular("(.*)(alias|status)es$", "\\1\\2");
        Noun.addSingular("^(ox)en", "\\1");
        Noun.addSingular("(.*)(vert|ind)ices$", "\\1\\2ex");
        Noun.addSingular("(.*)(matr)ices$", "\\1\\2ix");
        Noun.addSingular("(.*)(quiz)zes$", "\\1\\2");
        Noun.addIrregular("child", "children");
        Noun.addIrregular("man", "men");
        Noun.addIrregular("move", "moves");
        Noun.addIrregular("person", "people");
        Noun.addIrregular("sex", "sexes");
        Noun.addUncountable("equipment");
        Noun.addUncountable("fish");
        Noun.addUncountable("information");
        Noun.addUncountable("money");
        Noun.addUncountable("rice");
        Noun.addUncountable("series");
        Noun.addUncountable("sheep");
        Noun.addUncountable("species");
    }

    private static class Replacer {
        Pattern pattern = null;
        String rule = null;

        public Replacer(String match, String rule, boolean insensitive) {
            this.pattern = Pattern.compile(match, insensitive ? 2 : 0);
            this.rule = rule;
        }
    }
}

