/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.navigators;

import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.sequences.EmptySequence;
import jlibs.core.graph.sequences.FilteredTreeSequence;

public class FilteredTreeNavigator<E>
implements Navigator<E> {
    private Navigator<E> delegate;
    private Filter<E> filter;

    public FilteredTreeNavigator(Navigator<E> delegate) {
        this(delegate, null);
    }

    public FilteredTreeNavigator(Navigator<E> delegate, Filter<E> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Sequence<? extends E> children(E elem) {
        Sequence<E> seq = this.delegate.children(elem);
        if (seq == null) {
            return EmptySequence.getInstance();
        }
        if (this.filter != null) {
            seq = new FilteredTreeSequence<E>(seq, this, this.filter);
        }
        return seq;
    }
}

