/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.annotation.processing;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.lang.model.ModelUtil;

public class Printer {
    public static final String PLUS = "indent++";
    public static final String MINUS = "indent--";
    public TypeElement clazz;
    public String generatedQName;
    public String generatedPakage;
    public String generatedClazz;
    public int indent;
    PrintWriter ps;
    private boolean doIndent = true;
    private boolean emptyLine;
    private static Map<TypeElement, Printer> registry = new HashMap<TypeElement, Printer>();

    public Printer(PrintWriter ps) {
        this.ps = ps;
    }

    private void indent() {
        if (this.doIndent) {
            if (this.emptyLine) {
                this.println();
                this.emptyLine = false;
            }
            for (int i = 0; i < this.indent; ++i) {
                this.ps.print("    ");
            }
        }
    }

    public void println(String str) {
        if (str.length() > 0) {
            this.indent();
        }
        this.ps.println(str);
        this.doIndent = true;
    }

    public void println(String ... tokens) {
        for (String token : tokens) {
            this.print(token);
        }
        this.println();
    }

    public void printlns(String ... lines) {
        for (String line : lines) {
            if (line == null) continue;
            if (line == PLUS) {
                ++this.indent;
                continue;
            }
            if (line == MINUS) {
                --this.indent;
                continue;
            }
            this.println(line);
        }
    }

    public void print(String str) {
        this.indent();
        this.ps.print(str);
        this.doIndent = false;
    }

    public void emptyLine(boolean reqd) {
        this.emptyLine = reqd;
    }

    public void println() {
        this.ps.println();
        this.doIndent = true;
    }

    public void close() {
        this.ps.close();
    }

    public static Printer get(TypeElement clazz, Class annotation, String format) throws IOException {
        Printer printer = registry.get(clazz);
        if (printer == null) {
            String[] str = ModelUtil.findClass(clazz, format);
            if (ModelUtil.exists(str[1], str[2] + ".java")) {
                throw new AnnotationError((Element)clazz, ModelUtil.getAnnotationMirror(clazz, annotation), "Class " + str[0] + " already exists in source path");
            }
            PrintWriter writer = new PrintWriter(Environment.get().getFiler().createSourceFile(str[0], new Element[0]).openWriter());
            printer = new Printer(writer);
            printer.clazz = clazz;
            printer.generatedQName = str[0];
            printer.generatedPakage = str[1];
            printer.generatedClazz = str[2];
            registry.put(clazz, printer);
        }
        return printer;
    }

    public void printPackage() {
        if (this.generatedPakage != null && this.generatedPakage.length() > 0) {
            this.println("package " + this.generatedPakage + ";");
            this.emptyLine(true);
        }
    }

    public void importClass(Class clazz) {
        this.println("import " + clazz.getName() + ';');
    }

    public void importClass(TypeElement clazz) {
        this.println("import " + ModelUtil.toString(clazz.asType(), true) + ";");
    }

    public void importPackage(Class clazz) {
        Package pakage = clazz.getPackage();
        if (pakage != null) {
            this.println("import " + pakage.getName() + ".*;");
        }
    }

    public void printClassDoc() {
        this.println("/**");
        this.println(" * DON'T EDIT THIS FILE. THIS IS GENERATED BY JLIBS");
        this.println(" *");
        this.println(" * @author Santhosh Kumar T");
        this.println(" */");
    }

    public void titleComment(String title) {
        this.emptyLine(true);
        this.println("/*-------------------------------------------------[ " + title + " ]---------------------------------------------------*/");
        this.emptyLine(true);
    }

    public void printlnIf(String condition, String ... body) {
        this.printlnIf(condition, Arrays.asList(body));
    }

    public void printlnIf(String condition, List<String> body) {
        this.printlns("if(" + condition + ")" + (body.size() > 1 ? "{" : ""), PLUS);
        this.printlns(body.toArray(new String[body.size()]));
        this.printlns(MINUS, body.size() > 1 ? "}" : null);
    }

    public void printlnIf(String condition, List<String> ifBody, List<String> elseBody) {
        if (ifBody.size() == 1 && elseBody.size() == 1 && ifBody.get(0).equals("return true;") && elseBody.get(0).equals("return false;")) {
            this.println("return " + condition + ";");
        } else {
            this.printlns("if(" + condition + ")" + (ifBody.size() > 1 ? "{" : ""), PLUS);
            this.printlns(ifBody.toArray(new String[ifBody.size()]));
            this.printlns(MINUS, (ifBody.size() > 1 ? "}" : "") + "else" + (elseBody.size() > 1 ? "{" : ""), PLUS);
            this.printlns(elseBody.toArray(new String[elseBody.size()]));
            this.printlns(MINUS, elseBody.size() > 1 ? "}" : null);
        }
    }
}

