/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleLabel;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.Linkable;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.MutablePortNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Serializer {
    private final MutableGraph graph;
    private final StringBuilder str;

    public Serializer(MutableGraph graph) {
        this.graph = graph;
        this.str = new StringBuilder();
    }

    public String serialize() {
        this.graph(this.graph, true);
        return this.str.toString();
    }

    private void graph(MutableGraph graph, boolean toplevel) {
        this.graphInit(graph, toplevel);
        this.graphAttrs(graph);
        ArrayList<MutableNode> nodes = new ArrayList<MutableNode>();
        ArrayList<MutableGraph> graphs = new ArrayList<MutableGraph>();
        Collection<Linkable> linkables = this.linkedNodes(graph.nodes);
        linkables.addAll(this.linkedNodes(graph.subgraphs));
        for (Linkable linkable : linkables) {
            if (linkable instanceof MutableNode) {
                MutableNode node = (MutableNode)linkable;
                int i = this.indexOfName(nodes, node.name);
                if (i < 0) {
                    nodes.add(node);
                    continue;
                }
                nodes.set(i, node.copy().merge((MutableNode)nodes.get(i)));
                continue;
            }
            graphs.add((MutableGraph)linkable);
        }
        this.nodes(graph, nodes);
        this.graphs(graphs, nodes);
        this.edges(nodes);
        this.edges(graphs);
        this.str.append('}');
    }

    private void graphAttrs(MutableGraph graph) {
        this.attributes("graph", graph.graphAttrs);
        this.attributes("node", graph.nodeAttrs);
        this.attributes("edge", graph.linkAttrs);
    }

    private void graphInit(MutableGraph graph, boolean toplevel) {
        if (toplevel) {
            this.str.append(graph.strict ? "strict " : "").append(graph.directed ? "digraph " : "graph ");
            if (!graph.name.isEmpty()) {
                this.str.append(SimpleLabel.of(graph.name).serialized()).append(' ');
            }
        } else if (!graph.name.isEmpty() || graph.cluster) {
            this.str.append("subgraph ").append(Label.of((graph.cluster ? "cluster_" : "") + graph.name).serialized()).append(' ');
        }
        this.str.append("{\n");
    }

    private int indexOfName(List<MutableNode> nodes, Label name) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get((int)i).name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void attributes(String name, MutableAttributed<?> attributed) {
        if (!attributed.isEmpty()) {
            this.str.append(name);
            this.attrs(attributed);
            this.str.append('\n');
        }
    }

    private Collection<Linkable> linkedNodes(Collection<? extends Linkable> nodes) {
        LinkedHashSet<Linkable> visited = new LinkedHashSet<Linkable>();
        for (Linkable linkable : nodes) {
            this.linkedNodes(linkable, visited);
        }
        return visited;
    }

    private void linkedNodes(Linkable linkable, Set<Linkable> visited) {
        if (!visited.contains(linkable)) {
            visited.add(linkable);
            for (Link link : linkable.links()) {
                if (link.to instanceof MutableNode) {
                    this.linkedNodes((MutableNode)link.to, visited);
                    continue;
                }
                if (link.to instanceof MutablePortNode) {
                    this.linkedNodes(((MutablePortNode)link.to).node, visited);
                    continue;
                }
                if (link.to instanceof MutableGraph) {
                    this.linkedNodes((MutableGraph)link.to, visited);
                    continue;
                }
                throw new IllegalStateException("unexpected link to " + link.to + " of " + link.to.getClass());
            }
        }
    }

    private void nodes(MutableGraph graph, List<MutableNode> nodes) {
        for (MutableNode node : nodes) {
            if (node.attributes.isEmpty() && (!graph.nodes.contains(node) || !node.links.isEmpty())) continue;
            this.node(node);
            this.str.append('\n');
        }
    }

    private void graphs(List<MutableGraph> graphs, List<MutableNode> nodes) {
        for (MutableGraph graph : graphs) {
            if (!graph.links.isEmpty() || this.isLinked(graph, nodes) || this.isLinked(graph, graphs)) continue;
            this.graph(graph, false);
            this.str.append('\n');
        }
    }

    private boolean isLinked(MutableGraph graph, List<? extends Linkable> linkables) {
        for (Linkable linkable : linkables) {
            for (Link link : linkable.links()) {
                if (!link.to.equals(graph)) continue;
                return true;
            }
        }
        return false;
    }

    private void edges(List<? extends Linkable> linkables) {
        for (Linkable linkable : linkables) {
            for (Link link : linkable.links()) {
                this.linkTarget(link.from);
                this.str.append(this.graph.directed ? " -> " : " -- ");
                this.linkTarget(link.to);
                this.attrs(link.attributes);
                this.str.append('\n');
            }
        }
    }

    private void linkTarget(Object linkable) {
        if (linkable instanceof MutableNode) {
            this.node((MutableNode)linkable);
        } else if (linkable instanceof MutablePortNode) {
            this.port((MutablePortNode)linkable);
        } else if (linkable instanceof MutableGraph) {
            this.graph((MutableGraph)linkable, false);
        } else {
            throw new IllegalStateException("unexpected link target " + linkable);
        }
    }

    private void node(MutableNode node) {
        this.str.append(node.name.serialized());
        this.attrs(node.attributes);
    }

    private void port(MutablePortNode portNode) {
        this.str.append(portNode.node.name.serialized());
        if (portNode.record != null) {
            this.str.append(':').append(SimpleLabel.of(portNode.record).serialized());
        }
        if (portNode.compass != null) {
            this.str.append(':').append(portNode.compass.value);
        }
    }

    private void attrs(MutableAttributed<?> attrs) {
        if (!attrs.isEmpty()) {
            this.str.append(" [");
            boolean first = true;
            for (Map.Entry entry : attrs) {
                if (first) {
                    first = false;
                } else {
                    this.str.append(',');
                }
                this.attr((String)entry.getKey(), entry.getValue());
            }
            this.str.append(']');
        }
    }

    private void attr(String key, Object value) {
        this.str.append(SimpleLabel.of(key).serialized()).append('=').append(SimpleLabel.of(value).serialized());
    }
}

