/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.AttributeConfig;
import guru.nidi.graphviz.attribute.validate.Datatypes;
import guru.nidi.graphviz.attribute.validate.ValidatorEngine;
import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class AttributeConfigs {
    private static final double EPSILON = 1.0E-8;
    private static final Map<String, List<AttributeConfig>> CONFIG = new HashMap<String, List<AttributeConfig>>();

    private AttributeConfigs() {
    }

    static List<AttributeConfig> get(String name) {
        return CONFIG.get(name);
    }

    private static void add(String name, AttributeConfig entry) {
        CONFIG.put(name, Collections.singletonList(entry));
    }

    private static void add(String name, AttributeConfig ... entries) {
        CONFIG.put(name, Arrays.asList(entries));
    }

    static {
        AttributeConfigs.add("Damping", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)0.99, (Double)0.0).engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("K", AttributeConfig.entry("GC", Datatypes.DOUBLE, (Object)0.3, (Double)0.0).engines(ValidatorEngine.SFDP, ValidatorEngine.FDP));
        AttributeConfigs.add("URL", AttributeConfig.entry("ENGC", Datatypes.ESC_STRING).formats(ValidatorFormat.SVG, ValidatorFormat.POSTSCRIPT, ValidatorFormat.MAP));
        AttributeConfigs.add("_background", AttributeConfig.entry("G", Datatypes.STRING));
        AttributeConfigs.add("area", AttributeConfig.entry("NC", Datatypes.DOUBLE, (Object)1.0, (Double)1.0E-8).engines(ValidatorEngine.PATCHWORK));
        AttributeConfigs.add("arrowhead", AttributeConfig.entry("E", Datatypes.ARROW_TYPE, (Object)"normal"));
        AttributeConfigs.add("arrowsize", AttributeConfig.entry("E", Datatypes.DOUBLE, (Object)1.0, (Double)0.0));
        AttributeConfigs.add("arrowtail", AttributeConfig.entry("E", Datatypes.ARROW_TYPE, (Object)"normal"));
        AttributeConfigs.add("bb", AttributeConfig.entry("G", Datatypes.RECT).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("bgcolor", AttributeConfig.entry("GC", Arrays.asList(Datatypes.COLOR, Datatypes.COLOR_LIST)));
        AttributeConfigs.add("center", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("charset", AttributeConfig.entry("G", Datatypes.STRING, (Object)"UTF-8"));
        AttributeConfigs.add("clusterrank", AttributeConfig.entry("G", Datatypes.CLUSTER_MODE, (Object)"local").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("color", AttributeConfig.entry("ENC", Arrays.asList(Datatypes.COLOR, Datatypes.COLOR_LIST), (Object)"black"));
        AttributeConfigs.add("colorscheme", AttributeConfig.entry("ENCG", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("comment", AttributeConfig.entry("ENG", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("compound", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("concentrate", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("constraint", AttributeConfig.entry("E", Datatypes.BOOL, (Object)true).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("decorate", AttributeConfig.entry("E", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("defaultdist", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)"1+(avg. len)*sqrt(|V|)", (Double)1.0E-8).engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("dim", AttributeConfig.entry("G", Datatypes.INT, (Object)2, (Double)2.0).engines(ValidatorEngine.SFDP, ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("dimen", AttributeConfig.entry("G", Datatypes.INT, (Object)2, (Double)2.0).engines(ValidatorEngine.SFDP, ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("dir", AttributeConfig.entry("E", Datatypes.DIR_TYPE, (Object)"forward(directed)<BR>none(undirected)"));
        AttributeConfigs.add("diredgeconstraints", AttributeConfig.entry("G", Arrays.asList(Datatypes.STRING, Datatypes.BOOL), (Object)false).engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("distortion", AttributeConfig.entry("N", Datatypes.DOUBLE, (Object)0.0, (Double)-100.0));
        AttributeConfigs.add("dpi", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)72.0).formats(ValidatorFormat.SVG, ValidatorFormat.BITMAP));
        AttributeConfigs.add("edgeURL", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("edgehref", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("edgetarget", AttributeConfig.entry("E", Datatypes.ESC_STRING).formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("edgetooltip", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.CMAP));
        AttributeConfigs.add("epsilon", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)".0001 * # nodes(mode == KK)<BR>.0001(mode == major)").engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("esep", AttributeConfig.entry("G", Arrays.asList(Datatypes.ADD_DOUBLE, Datatypes.ADD_POINT), (Object)"+3").engines(ValidatorEngine.NOT_DOT));
        AttributeConfigs.add("fillcolor", AttributeConfig.entry("NEC", Arrays.asList(Datatypes.COLOR, Datatypes.COLOR_LIST), (Object)"lightgrey(nodes)<BR>black(clusters"));
        AttributeConfigs.add("fixedsize", AttributeConfig.entry("N", Arrays.asList(Datatypes.BOOL, Datatypes.STRING), (Object)false));
        AttributeConfigs.add("fontcolor", AttributeConfig.entry("ENGC", Datatypes.COLOR, (Object)"black"));
        AttributeConfigs.add("fontname", AttributeConfig.entry("ENGC", Datatypes.STRING, (Object)"Times-Roman"));
        AttributeConfigs.add("fontnames", AttributeConfig.entry("G", Datatypes.STRING, (Object)"").formats(ValidatorFormat.SVG));
        AttributeConfigs.add("fontpath", AttributeConfig.entry("G", Datatypes.STRING, (Object)"system-dependent"));
        AttributeConfigs.add("fontsize", AttributeConfig.entry("ENGC", Datatypes.DOUBLE, (Object)14.0, (Double)1.0));
        AttributeConfigs.add("forcelabels", AttributeConfig.entry("G", Datatypes.BOOL, (Object)true));
        AttributeConfigs.add("gradientangle", AttributeConfig.entry("NCG", Datatypes.INT, (Object)0));
        AttributeConfigs.add("group", AttributeConfig.entry("N", Datatypes.STRING, (Object)"").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("headURL", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("head_lp", AttributeConfig.entry("E", Datatypes.POINT).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("headclip", AttributeConfig.entry("E", Datatypes.BOOL, (Object)true));
        AttributeConfigs.add("headhref", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("headlabel", AttributeConfig.entry("E", Datatypes.LBL_STRING, (Object)""));
        AttributeConfigs.add("headport", AttributeConfig.entry("E", Datatypes.PORT_POS, (Object)"center"));
        AttributeConfigs.add("headtarget", AttributeConfig.entry("E", Datatypes.ESC_STRING).formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("headtooltip", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.CMAP));
        AttributeConfigs.add("height", AttributeConfig.entry("N", Datatypes.DOUBLE, (Object)0.5, (Double)0.02));
        AttributeConfigs.add("href", AttributeConfig.entry("GCNE", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.POSTSCRIPT, ValidatorFormat.MAP));
        AttributeConfigs.add("id", AttributeConfig.entry("GCNE", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.POSTSCRIPT, ValidatorFormat.MAP));
        AttributeConfigs.add("image", AttributeConfig.entry("N", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("imagepath", AttributeConfig.entry("G", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("imagepos", AttributeConfig.entry("N", Datatypes.STRING, (Object)"mc"));
        AttributeConfigs.add("imagescale", AttributeConfig.entry("N", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("inputscale", AttributeConfig.entry("G", Datatypes.DOUBLE).engines(ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("label", AttributeConfig.entry("ENGC", Datatypes.LBL_STRING, (Object)"\\N(nodes)<BR>''(otherwise)"));
        AttributeConfigs.add("labelURL", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("label_scheme", AttributeConfig.entry("G", Datatypes.INT, (Object)0, (Double)0.0).engines(ValidatorEngine.SFDP));
        AttributeConfigs.add("labelangle", AttributeConfig.entry("E", Datatypes.DOUBLE, (Object)-25.0, (Double)-180.0));
        AttributeConfigs.add("labeldistance", AttributeConfig.entry("E", Datatypes.DOUBLE, (Object)1.0, (Double)0.0));
        AttributeConfigs.add("labelfloat", AttributeConfig.entry("E", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("labelfontcolor", AttributeConfig.entry("E", Datatypes.COLOR, (Object)"black"));
        AttributeConfigs.add("labelfontname", AttributeConfig.entry("E", Datatypes.STRING, (Object)"Times-Roman"));
        AttributeConfigs.add("labelfontsize", AttributeConfig.entry("E", Datatypes.DOUBLE, (Object)14.0, (Double)1.0));
        AttributeConfigs.add("labelhref", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("labeljust", AttributeConfig.entry("GC", Datatypes.STRING, (Object)"c"));
        AttributeConfigs.add("labelloc", AttributeConfig.entry("NGC", Datatypes.STRING, (Object)"'t'(clusters)<BR>'b'(root graphs)<BR>'c'(nodes)"));
        AttributeConfigs.add("labeltarget", AttributeConfig.entry("E", Datatypes.ESC_STRING).formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("labeltooltip", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.CMAP));
        AttributeConfigs.add("landscape", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("layer", AttributeConfig.entry("ENC", Datatypes.LAYER_RANGE, (Object)""));
        AttributeConfigs.add("layerlistsep", AttributeConfig.entry("G", Datatypes.STRING, (Object)","));
        AttributeConfigs.add("layers", AttributeConfig.entry("G", Datatypes.LAYER_LIST, (Object)""));
        AttributeConfigs.add("layerselect", AttributeConfig.entry("G", Datatypes.LAYER_RANGE, (Object)""));
        AttributeConfigs.add("layersep", AttributeConfig.entry("G", Datatypes.STRING, (Object)":\\t"));
        AttributeConfigs.add("layout", AttributeConfig.entry("G", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("len", AttributeConfig.entry("E", Datatypes.DOUBLE, (Object)"1.0(neato)<BR>0.3(fdp)").engines(ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("levels", AttributeConfig.entry("G", Datatypes.INT, (Object)Integer.MAX_VALUE, (Double)0.0).engines(ValidatorEngine.SFDP));
        AttributeConfigs.add("levelsgap", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)0.0).engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("lhead", AttributeConfig.entry("E", Datatypes.STRING, (Object)"").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("lheight", AttributeConfig.entry("GC", Datatypes.DOUBLE).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("lp", AttributeConfig.entry("EGC", Datatypes.POINT).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("ltail", AttributeConfig.entry("E", Datatypes.STRING, (Object)"").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("lwidth", AttributeConfig.entry("GC", Datatypes.DOUBLE).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("margin", AttributeConfig.entry("NCG", Arrays.asList(Datatypes.DOUBLE, Datatypes.POINT), (Object)"&#60;device-dependent&#62;"));
        AttributeConfigs.add("maxiter", AttributeConfig.entry("G", Datatypes.INT, (Object)"100 nodes(mode == KK)<BR>200(mode == major)<BR>600(fdp)").engines(ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("mclimit", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)1.0).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("mindist", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)1.0, (Double)0.0).engines(ValidatorEngine.CIRCO));
        AttributeConfigs.add("minlen", AttributeConfig.entry("E", Datatypes.INT, (Object)1, (Double)0.0).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("mode", AttributeConfig.entry("G", Datatypes.STRING, (Object)"major").engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("model", AttributeConfig.entry("G", Datatypes.STRING, (Object)"shortpath").engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("mosek", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false).engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("newrank", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("nodesep", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)0.25, (Double)0.02));
        AttributeConfigs.add("nojustify", AttributeConfig.entry("GCNE", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("normalize", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.BOOL), (Object)false).engines(ValidatorEngine.NOT_DOT));
        AttributeConfigs.add("notranslate", AttributeConfig.entry("G", Datatypes.BOOL, (Object)false).engines(ValidatorEngine.NEATO));
        AttributeConfigs.add("nslimit", AttributeConfig.entry("G", Datatypes.DOUBLE).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("nslimit1", AttributeConfig.entry("G", Datatypes.DOUBLE).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("ordering", AttributeConfig.entry("GN", Datatypes.STRING, (Object)"").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("orientation", AttributeConfig.entry("N", Datatypes.DOUBLE, (Object)0.0, (Double)0.0, (Double)360.0), AttributeConfig.entry("G", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("outputorder", AttributeConfig.entry("G", Datatypes.OUTPUT_MODE, (Object)"breadthfirst"));
        AttributeConfigs.add("overlap", AttributeConfig.entry("G", Arrays.asList(Datatypes.STRING, Datatypes.BOOL), (Object)true).engines(ValidatorEngine.NOT_DOT));
        AttributeConfigs.add("overlap_scaling", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)-4.0, (Double)-1.0E10));
        AttributeConfigs.add("overlap_shrink", AttributeConfig.entry("G", Datatypes.BOOL, (Object)true));
        AttributeConfigs.add("pack", AttributeConfig.entry("G", Arrays.asList(Datatypes.BOOL, Datatypes.INT), (Object)false));
        AttributeConfigs.add("packmode", AttributeConfig.entry("G", Datatypes.PACK_MODE, (Object)"node"));
        AttributeConfigs.add("pad", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.POINT), (Object)0.0555));
        AttributeConfigs.add("page", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.POINT)));
        AttributeConfigs.add("pagedir", AttributeConfig.entry("G", Datatypes.PAGE_DIR, (Object)"BL"));
        AttributeConfigs.add("pencolor", AttributeConfig.entry("C", Datatypes.COLOR, (Object)"black"));
        AttributeConfigs.add("penwidth", AttributeConfig.entry("CNE", Datatypes.DOUBLE, (Object)1.0, (Double)0.0));
        AttributeConfigs.add("peripheries", AttributeConfig.entry("NC", Datatypes.INT, (Object)"shape default(nodes)<BR>1(clusters)", (Double)0.0));
        AttributeConfigs.add("pin", AttributeConfig.entry("N", Datatypes.BOOL, (Object)false).engines(ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("pos", AttributeConfig.entry("EN", Arrays.asList(Datatypes.POINT, Datatypes.SPLINE_TYPE)));
        AttributeConfigs.add("quadtree", AttributeConfig.entry("G", Arrays.asList(Datatypes.QUAD_TYPE, Datatypes.BOOL), (Object)"normal").engines(ValidatorEngine.SFDP));
        AttributeConfigs.add("quantum", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)0.0, (Double)0.0));
        AttributeConfigs.add("rank", AttributeConfig.entry("S", Datatypes.RANK_TYPE).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("rankdir", AttributeConfig.entry("G", Datatypes.RANK_DIR, (Object)"TB").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("ranksep", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.DOUBLE_LIST), (Object)"0.5(dot)<BR>1.0(twopi)", (Double)0.02).engines(ValidatorEngine.TWOPI, ValidatorEngine.DOT));
        AttributeConfigs.add("ratio", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.STRING)));
        AttributeConfigs.add("rects", AttributeConfig.entry("N", Datatypes.RECT).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("regular", AttributeConfig.entry("N", Datatypes.BOOL, (Object)false));
        AttributeConfigs.add("remincross", AttributeConfig.entry("G", Datatypes.BOOL, (Object)true).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("repulsiveforce", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)1.0, (Double)0.0).engines(ValidatorEngine.SFDP));
        AttributeConfigs.add("resolution", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)72.0).formats(ValidatorFormat.SVG, ValidatorFormat.BITMAP));
        AttributeConfigs.add("root", AttributeConfig.entry("GN", Arrays.asList(Datatypes.STRING, Datatypes.BOOL), (Object)"&#60;none&#62;(graphs)<BR>false(nodes)").engines(ValidatorEngine.CIRCO, ValidatorEngine.TWOPI));
        AttributeConfigs.add("rotate", AttributeConfig.entry("G", Datatypes.INT, (Object)0));
        AttributeConfigs.add("rotation", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)0).engines(ValidatorEngine.SFDP));
        AttributeConfigs.add("samehead", AttributeConfig.entry("E", Datatypes.STRING, (Object)"").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("sametail", AttributeConfig.entry("E", Datatypes.STRING, (Object)"").engines(ValidatorEngine.DOT));
        AttributeConfigs.add("samplepoints", AttributeConfig.entry("N", Datatypes.INT, (Object)"8(output)<BR>20(overlap and image maps)"));
        AttributeConfigs.add("scale", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.POINT)).engines(ValidatorEngine.NOT_DOT));
        AttributeConfigs.add("searchsize", AttributeConfig.entry("G", Datatypes.INT, (Object)30).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("sep", AttributeConfig.entry("G", Arrays.asList(Datatypes.ADD_DOUBLE, Datatypes.ADD_POINT), (Object)"+4").engines(ValidatorEngine.NOT_DOT));
        AttributeConfigs.add("shape", AttributeConfig.entry("N", Datatypes.SHAPE, (Object)"ellipse"));
        AttributeConfigs.add("shapefile", AttributeConfig.entry("N", Datatypes.STRING, (Object)""));
        AttributeConfigs.add("showboxes", AttributeConfig.entry("ENG", Datatypes.INT, (Object)0, (Double)0.0).engines(ValidatorEngine.DOT));
        AttributeConfigs.add("sides", AttributeConfig.entry("N", Datatypes.INT, (Object)4, (Double)0.0));
        AttributeConfigs.add("size", AttributeConfig.entry("G", Arrays.asList(Datatypes.DOUBLE, Datatypes.POINT)));
        AttributeConfigs.add("skew", AttributeConfig.entry("N", Datatypes.DOUBLE, (Object)0.0, (Double)-100.0));
        AttributeConfigs.add("smoothing", AttributeConfig.entry("G", Datatypes.SMOOTH_TYPE, (Object)"none").engines(ValidatorEngine.SFDP));
        AttributeConfigs.add("sortv", AttributeConfig.entry("GCN", Datatypes.INT, (Object)0, (Double)0.0));
        AttributeConfigs.add("splines", AttributeConfig.entry("G", Arrays.asList(Datatypes.BOOL, Datatypes.STRING)));
        AttributeConfigs.add("start", AttributeConfig.entry("G", Datatypes.START_TYPE, (Object)"").engines(ValidatorEngine.FDP, ValidatorEngine.NEATO));
        AttributeConfigs.add("style", AttributeConfig.entry("ENCG", Datatypes.STYLE, (Object)""));
        AttributeConfigs.add("stylesheet", AttributeConfig.entry("G", Datatypes.STRING, (Object)"").formats(ValidatorFormat.SVG));
        AttributeConfigs.add("tailURL", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("tail_lp", AttributeConfig.entry("E", Datatypes.POINT).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("tailclip", AttributeConfig.entry("E", Datatypes.BOOL, (Object)true));
        AttributeConfigs.add("tailhref", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("taillabel", AttributeConfig.entry("E", Datatypes.LBL_STRING, (Object)""));
        AttributeConfigs.add("tailport", AttributeConfig.entry("E", Datatypes.PORT_POS, (Object)"center"));
        AttributeConfigs.add("tailtarget", AttributeConfig.entry("E", Datatypes.ESC_STRING).formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("tailtooltip", AttributeConfig.entry("E", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.CMAP));
        AttributeConfigs.add("target", AttributeConfig.entry("ENGC", Arrays.asList(Datatypes.ESC_STRING, Datatypes.STRING)).formats(ValidatorFormat.SVG, ValidatorFormat.MAP));
        AttributeConfigs.add("tooltip", AttributeConfig.entry("NEC", Datatypes.ESC_STRING, (Object)"").formats(ValidatorFormat.SVG, ValidatorFormat.CMAP));
        AttributeConfigs.add("truecolor", AttributeConfig.entry("G", Datatypes.BOOL).formats(ValidatorFormat.BITMAP));
        AttributeConfigs.add("vertices", AttributeConfig.entry("N", Datatypes.POINT_LIST).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("viewport", AttributeConfig.entry("G", Datatypes.VIEW_PORT, (Object)""));
        AttributeConfigs.add("voro_margin", AttributeConfig.entry("G", Datatypes.DOUBLE, (Object)0.05, (Double)0.0).engines(ValidatorEngine.NOT_DOT));
        AttributeConfigs.add("weight", AttributeConfig.entry("E", Arrays.asList(Datatypes.INT, Datatypes.DOUBLE), (Object)1, (Double)0.0).engines(ValidatorEngine.DOT, ValidatorEngine.TWOPI), AttributeConfig.entry("E", Arrays.asList(Datatypes.INT, Datatypes.DOUBLE), (Object)1, (Double)1.0).engines(ValidatorEngine.NEATO, ValidatorEngine.FDP));
        AttributeConfigs.add("width", AttributeConfig.entry("N", Datatypes.DOUBLE, (Object)0.75, (Double)0.01));
        AttributeConfigs.add("xdotversion", AttributeConfig.entry("G", Datatypes.STRING).formats(ValidatorFormat.XDOT));
        AttributeConfigs.add("xlabel", AttributeConfig.entry("EN", Datatypes.LBL_STRING, (Object)""));
        AttributeConfigs.add("xlp", AttributeConfig.entry("NE", Datatypes.POINT).formats(ValidatorFormat.WRITE));
        AttributeConfigs.add("z", AttributeConfig.entry("N", Datatypes.DOUBLE, (Object)0.0, (Double)-1000.0));
    }
}

