/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.timer.ExecutorTask;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.ThreadPooledTimer;
import org.apache.geronimo.timer.WorkInfo;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class TransactionalExecutorTask
implements ExecutorTask {
    private static final Log log = LogFactory.getLog((Class)TransactionalExecutorTask.class);
    private final Runnable userTask;
    private final WorkInfo workInfo;
    private final ThreadPooledTimer threadPooledTimer;
    private final TransactionContextManager transactionContextManager;
    private final int repeatCount;

    public TransactionalExecutorTask(Runnable userTask, WorkInfo workInfo, ThreadPooledTimer threadPooledTimer, TransactionContextManager transactionContextManager, int repeatCount) {
        this.userTask = userTask;
        this.workInfo = workInfo;
        this.threadPooledTimer = threadPooledTimer;
        this.transactionContextManager = transactionContextManager;
        this.repeatCount = repeatCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TransactionContext transactionContext = null;
        for (int tries = 0; tries < this.repeatCount; ++tries) {
            Exception e5;
            Object var5_7;
            try {
                transactionContext = this.transactionContextManager.newContainerTransactionContext();
            }
            catch (Exception e2) {
                log.warn((Object)"Exception occured while starting container transaction", (Throwable)e2);
                break;
            }
            try {
                try {
                    this.userTask.run();
                }
                catch (Exception e3) {
                    log.warn((Object)"Exception occured while running user task", (Throwable)e3);
                }
                try {
                    this.threadPooledTimer.workPerformed(this.workInfo);
                }
                catch (PersistenceException e4) {
                    log.warn((Object)"Exception occured while updating timer persistent state", (Throwable)e4);
                }
                var5_7 = null;
            }
            catch (Throwable throwable) {
                var5_7 = null;
                try {
                    this.transactionContextManager.setContext(null);
                    if (transactionContext.commit()) {
                        if (this.workInfo.isOneTime()) {
                            this.threadPooledTimer.removeWorkInfo(this.workInfo);
                        }
                        return;
                    }
                }
                catch (Exception e5) {
                    log.warn((Object)"Exception occured while completing container transaction", (Throwable)e5);
                }
                throw throwable;
            }
            try {
                this.transactionContextManager.setContext(null);
                if (!transactionContext.commit()) continue;
                if (this.workInfo.isOneTime()) {
                    this.threadPooledTimer.removeWorkInfo(this.workInfo);
                }
                return;
            }
            catch (Exception e5) {
                log.warn((Object)"Exception occured while completing container transaction", (Throwable)e5);
            }
        }
        if (this.workInfo.isOneTime()) {
            this.threadPooledTimer.removeWorkInfo(this.workInfo);
        }
        log.warn((Object)"Failed to execute work successfully");
    }
}

