/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.timer.ExecutorTask;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.ThreadPooledTimer;
import org.apache.geronimo.timer.WorkInfo;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class NontransactionalExecutorTask
implements ExecutorTask {
    private static final Log log = LogFactory.getLog((Class)NontransactionalExecutorTask.class);
    private final Runnable userTask;
    private final WorkInfo workInfo;
    private final ThreadPooledTimer threadPooledTimer;
    private final TransactionContextManager transactionContextManager;

    public NontransactionalExecutorTask(Runnable userTask, WorkInfo workInfo, ThreadPooledTimer threadPooledTimer, TransactionContextManager transactionContextManager) {
        this.userTask = userTask;
        this.workInfo = workInfo;
        this.threadPooledTimer = threadPooledTimer;
        this.transactionContextManager = transactionContextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TransactionContext oldTransactionContext;
        block10: {
            oldTransactionContext = this.transactionContextManager.getContext();
            TransactionContext transactionContext = this.transactionContextManager.newUnspecifiedTransactionContext();
            try {
                try {
                    this.userTask.run();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception running task", (Throwable)e);
                }
                try {
                    this.threadPooledTimer.workPerformed(this.workInfo);
                }
                catch (PersistenceException e) {
                    log.warn((Object)"Exception completing task", (Throwable)e);
                }
                if (this.workInfo.isOneTime()) {
                    this.threadPooledTimer.removeWorkInfo(this.workInfo);
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    transactionContext.commit();
                }
                catch (Exception e) {
                    log.error((Object)"Unable to commit transaction context", (Throwable)e);
                }
                this.transactionContextManager.setContext(oldTransactionContext);
                throw throwable;
            }
            try {
                transactionContext.commit();
                break block10;
            }
            catch (Exception e) {
                log.error((Object)"Unable to commit transaction context", (Throwable)e);
            }
            {
            }
        }
        this.transactionContextManager.setContext(oldTransactionContext);
    }
}

