/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.repository;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class FileSystemRepository
implements Repository,
ListableRepository,
WriteableRepository,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)FileSystemRepository.class);
    private static final int TRANSFER_NOTIFICATION_SIZE = 10240;
    private static final int TRANSFER_BUF_SIZE = 10240;
    private final URI root;
    private final ServerInfo serverInfo;
    private URI rootURI;
    private File rootFile;
    private static final Pattern pattern = Pattern.compile("(.+)/(.+)s/(.+)-([0-9].+)\\.([^0-9]+)");
    public static final GBeanInfo GBEAN_INFO;

    public FileSystemRepository(URI root, ServerInfo serverInfo) {
        if (!root.toString().endsWith("/")) {
            try {
                root = new URI(root.toString() + "/");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid repository root (does not end with / ) and can't add myself", e);
            }
        }
        this.root = root;
        this.serverInfo = serverInfo;
    }

    public boolean hasURI(URI uri) {
        if ("file".equals((uri = this.resolve(uri)).getScheme())) {
            File f = new File(uri);
            return f.exists() && f.canRead();
        }
        return false;
    }

    public URL getURL(URI uri) throws MalformedURLException {
        URL url = this.resolve(uri).toURL();
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        return url;
    }

    private URI resolve(URI uri) {
        String[] bits = uri.toString().split("/");
        StringBuffer buf = new StringBuffer(bits[0]).append('/');
        String type = bits.length >= 4 ? bits[3] : "jar";
        buf.append(type).append('s').append('/').append(bits[1]).append('-').append(bits[2]).append('.').append(type);
        return this.rootURI.resolve(buf.toString());
    }

    public URI[] listURIs() throws URISyntaxException {
        String[] results = this.getFiles(this.rootFile, "");
        URI[] out = new URI[results.length];
        Matcher matcher = pattern.matcher("");
        for (int i = 0; i < out.length; ++i) {
            matcher.reset(results[i]);
            if (!matcher.matches()) continue;
            String groupId = matcher.group(1);
            String artifactId = matcher.group(3);
            String version = matcher.group(4);
            String type = matcher.group(5);
            StringBuffer buf = new StringBuffer(groupId).append("/").append(artifactId).append("/").append(version).append("/").append(type);
            out[i] = new URI(buf.toString());
        }
        return out;
    }

    public String[] getFiles(File base, String prefix) {
        if (!base.canRead() || !base.isDirectory()) {
            throw new IllegalArgumentException(base.getAbsolutePath());
        }
        ArrayList<String> list = new ArrayList<String>();
        File[] hits = base.listFiles();
        for (int i = 0; i < hits.length; ++i) {
            File hit = hits[i];
            if (!hit.canRead()) continue;
            if (hit.isDirectory()) {
                list.addAll(Arrays.asList(this.getFiles(hit, prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName())));
                continue;
            }
            list.add(prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public void copyToRepository(File source, URI destination, FileWriteMonitor monitor) throws IOException {
        if (!source.exists() || !source.canRead() || source.isDirectory()) {
            throw new IllegalArgumentException("Cannot read source file at " + source.getAbsolutePath());
        }
        this.copyToRepository(new FileInputStream(source), destination, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToRepository(InputStream source, URI destination, FileWriteMonitor monitor) throws IOException {
        if (!this.rootFile.canWrite()) {
            throw new IllegalStateException("This repository is not writable: " + this.rootFile.getAbsolutePath() + ")");
        }
        File dest = new File(this.resolve(destination));
        if (dest.exists()) {
            throw new IllegalArgumentException("Destination " + dest.getAbsolutePath() + " already exists!");
        }
        File parent = dest.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create directories from " + this.rootFile.getAbsolutePath() + " to " + parent.getAbsolutePath());
        }
        if (monitor != null) {
            monitor.writeStarted(destination.toString());
        }
        int total = 0;
        try {
            int count;
            int threshold = 10240;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            BufferedInputStream in = new BufferedInputStream(source);
            byte[] buf = new byte[10240];
            while ((count = in.read(buf)) > -1) {
                out.write(buf, 0, count);
                if (monitor == null || (total += count) <= threshold) continue;
                threshold += 10240;
                monitor.writeProgress(total);
            }
            out.flush();
            out.close();
            in.close();
        }
        finally {
            if (monitor != null) {
                monitor.writeComplete(total);
            }
        }
    }

    public void doStart() throws Exception {
        if (this.rootURI == null) {
            this.rootURI = this.serverInfo != null ? this.serverInfo.resolve(this.root) : this.root;
            if (!this.rootURI.getScheme().equals("file")) {
                throw new IllegalStateException("FileSystemRepository must have a root that's a local directory (not " + this.rootURI + ")");
            }
            this.rootFile = new File(this.rootURI);
            if (!(this.rootFile.exists() && this.rootFile.isDirectory() && this.rootFile.canRead())) {
                throw new IllegalStateException("FileSystemRepository must have a root that's a valid readable directory (not " + this.rootFile.getAbsolutePath() + ")");
            }
        }
        log.debug((Object)("Repository root is " + this.rootFile.getAbsolutePath()));
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)FileSystemRepository.class);
        infoFactory.addAttribute("root", URI.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(Repository.class);
        infoFactory.addInterface(ListableRepository.class);
        infoFactory.addInterface(WriteableRepository.class);
        infoFactory.setConstructor(new String[]{"root", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

