/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.system.main.StartupMonitor;

public class SilentStartupMonitor
implements StartupMonitor {
    private static final Log log = LogFactory.getLog((String)SilentStartupMonitor.class.getName());
    private Kernel kernel;

    public void systemStarting(long startTime) {
    }

    public void systemStarted(Kernel kernel) {
        this.kernel = kernel;
    }

    public void foundConfigurations(URI[] configurations) {
    }

    public void configurationLoading(URI configuration) {
    }

    public void configurationLoaded(URI configuration) {
    }

    public void configurationStarting(URI configuration) {
    }

    public void configurationStarted(URI configuration) {
    }

    public void startupFinished() {
        try {
            Set gbeans = this.kernel.listGBeans(ObjectName.getInstance("*:*"));
            Iterator it = gbeans.iterator();
            while (it.hasNext()) {
                ObjectName name = (ObjectName)it.next();
                int state = this.kernel.getGBeanState(name);
                if (state == 1) continue;
                log.warn((Object)("Unable to start " + name + " (" + State.fromInt((int)state).getName() + ")"));
            }
        }
        catch (MalformedObjectNameException e) {
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
        System.out.println("Geronimo startup complete");
    }

    public void serverStartFailed(Exception problem) {
        System.out.println("Geronimo startup failed:");
        problem.printStackTrace(System.out);
    }

    public void loadFailed(String configuration, Exception problem) {
        problem.printStackTrace();
    }

    public void startFailed(String configuration, Exception problem) {
        problem.printStackTrace();
    }
}

