/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import [Ljava.lang.String;;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoEnvironment;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.system.main.CommandLineManifest;
import org.apache.geronimo.system.main.ExceptionUtil;

public class CommandLine {
    protected static final Log log;
    private Kernel kernel;
    private GBeanData configuration;

    public static void main(String[] args) {
        log.info((Object)"Server startup begun");
        try {
            CommandLineManifest manifest = CommandLineManifest.getManifestEntries();
            List configurations = manifest.getConfigurations();
            ObjectName mainGBean = manifest.getMainGBean();
            String mainMethod = manifest.getMainMethod();
            new CommandLine().invokeMainGBean(configurations, mainGBean, mainMethod, args);
            log.info((Object)"Server shutdown completed");
        }
        catch (Exception e) {
            ExceptionUtil.trimStackTrace(e);
            e.printStackTrace();
            System.exit(2);
            throw new AssertionError();
        }
    }

    public void invokeMainGBean(List configurations, ObjectName mainGBean, String mainMethod, String[] args) throws Exception {
        this.startKernel(configurations);
        log.info((Object)"Server startup completed");
        this.kernel.invoke(mainGBean, mainMethod, new Object[]{args}, new String[]{String;.class.getName()});
        log.info((Object)"Server shutdown begun");
        this.stopKernel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startKernel(List configurations) throws Exception {
        this.configuration = new GBeanData();
        ClassLoader classLoader = CommandLine.class.getClassLoader();
        ObjectInputStream ois = new ObjectInputStream(classLoader.getResourceAsStream("META-INF/config.ser"));
        try {
            this.configuration.readExternal((ObjectInput)ois);
        }
        finally {
            ois.close();
        }
        URI configurationId = (URI)this.configuration.getAttribute("id");
        ObjectName configName = Configuration.getConfigurationObjectName((URI)configurationId);
        this.configuration.setName(configName);
        this.configuration.setAttribute("dependencies", (Object)Collections.EMPTY_LIST);
        this.configuration.setAttribute("baseURL", (Object)classLoader.getResource("/"));
        this.kernel = KernelFactory.newInstance().createKernel("geronimo");
        this.kernel.boot();
        this.kernel.loadGBean(this.configuration, classLoader);
        this.kernel.startGBean(configName);
        this.kernel.invoke(configName, "loadGBeans", new Object[]{null}, new String[]{ManageableAttributeStore.class.getName()});
        this.kernel.invoke(configName, "startRecursiveGBeans");
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        try {
            Iterator i = configurations.iterator();
            while (i.hasNext()) {
                URI configID = (URI)i.next();
                List list = configurationManager.loadRecursive(configID);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    URI name = (URI)iterator.next();
                    configurationManager.loadGBeans(name);
                    configurationManager.start(name);
                }
            }
        }
        finally {
            ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
        }
    }

    protected Kernel getKernel() {
        return this.kernel;
    }

    protected void stopKernel() throws GBeanNotFoundException, InternalKernelException {
        this.kernel.stopGBean(this.configuration.getName());
        this.kernel.shutdown();
    }

    static {
        GeronimoEnvironment.init();
        GeronimoLogging.initialize((GeronimoLogging)GeronimoLogging.ERROR);
        log = LogFactory.getLog((String)CommandLine.class.getName());
    }
}

