/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.system.jmx.MBeanGBeanBridge;
import org.apache.geronimo.system.jmx.MBeanServerNotFound;

public class MBeanServerKernelBridge
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)MBeanServerKernelBridge.class);
    private final HashMap registry = new HashMap();
    private final Kernel kernel;
    private final MBeanServer mbeanServer;
    private static final ObjectName ALL = JMXUtil.getObjectName((String)"*:*");
    public static final GBeanInfo GBEAN_INFO;

    public MBeanServerKernelBridge(Kernel kernel, String mbeanServerId) throws MBeanServerNotFound {
        this.kernel = kernel;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(mbeanServerId);
        if (servers.size() == 0) {
            throw new MBeanServerNotFound("No MBeanServers were found with the agent id " + mbeanServerId);
        }
        if (servers.size() > 1) {
            throw new MBeanServerNotFound(servers.size() + " MBeanServers were found with the agent id " + mbeanServerId);
        }
        this.mbeanServer = servers.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        this.kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)new GBeanRegistrationListener(), ALL);
        HashMap<ObjectName, MBeanGBeanBridge> beans = new HashMap<ObjectName, MBeanGBeanBridge>();
        MBeanServerKernelBridge mBeanServerKernelBridge = this;
        synchronized (mBeanServerKernelBridge) {
            Set allNames = this.kernel.listGBeans(ALL);
            Iterator iterator = allNames.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                if (this.registry.containsKey(objectName)) continue;
                MBeanInfo mbeanInfo = null;
                try {
                    mbeanInfo = JMXUtil.toMBeanInfo((GBeanInfo)this.kernel.getGBeanInfo(objectName));
                }
                catch (GBeanNotFoundException e) {
                    continue;
                }
                MBeanGBeanBridge mbeanGBeanBridge = new MBeanGBeanBridge(this.kernel, objectName, mbeanInfo);
                this.registry.put(objectName, mbeanGBeanBridge);
                beans.put(objectName, mbeanGBeanBridge);
            }
        }
        Iterator iterator = beans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ObjectName objectName = (ObjectName)entry.getKey();
            MBeanGBeanBridge bridge = (MBeanGBeanBridge)entry.getValue();
            try {
                this.mbeanServer.registerMBean(bridge, objectName);
            }
            catch (InstanceAlreadyExistsException e) {
            }
            catch (Exception e) {
                log.warn((Object)"Unable to register MBean shadow object for GBean", this.unwrapJMException(e));
            }
        }
    }

    public void doFail() {
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        HashMap beans;
        MBeanServerKernelBridge mBeanServerKernelBridge = this;
        synchronized (mBeanServerKernelBridge) {
            beans = new HashMap(this.registry);
            this.registry.clear();
        }
        Iterator i = beans.keySet().iterator();
        while (i.hasNext()) {
            ObjectName objectName = (ObjectName)i.next();
            try {
                this.mbeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ObjectName objectName) {
        try {
            MBeanGBeanBridge mbeanGBeanBridge = null;
            MBeanServerKernelBridge mBeanServerKernelBridge = this;
            synchronized (mBeanServerKernelBridge) {
                if (this.registry.containsKey(objectName)) {
                    return;
                }
                MBeanInfo mbeanInfo = JMXUtil.toMBeanInfo((GBeanInfo)this.kernel.getGBeanInfo(objectName));
                mbeanGBeanBridge = new MBeanGBeanBridge(this.kernel, objectName, mbeanInfo);
                this.registry.put(objectName, mbeanGBeanBridge);
            }
            this.mbeanServer.registerMBean(mbeanGBeanBridge, objectName);
        }
        catch (GBeanNotFoundException e) {
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (Exception e) {
            log.warn((Object)"Unable to register MBean shadow object for GBean", this.unwrapJMException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ObjectName objectName) {
        MBeanServerKernelBridge mBeanServerKernelBridge = this;
        synchronized (mBeanServerKernelBridge) {
            if (this.registry.remove(objectName) == null) {
                return;
            }
        }
        try {
            this.mbeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            log.warn((Object)"Unable to unregister MBean shadow object for GBean", this.unwrapJMException(e));
        }
    }

    private Throwable unwrapJMException(Throwable cause) {
        while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)MBeanServerKernelBridge.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("mbeanServerId", String.class, true);
        infoFactory.setConstructor(new String[]{"kernel", "mbeanServerId"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class GBeanRegistrationListener
    extends LifecycleAdapter {
        private GBeanRegistrationListener() {
        }

        public void loaded(ObjectName objectName) {
            MBeanServerKernelBridge.this.register(objectName);
        }

        public void unloaded(ObjectName objectName) {
            MBeanServerKernelBridge.this.unregister(objectName);
        }
    }
}

