/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.NotificationType;

public final class MBeanGBeanBridge
implements MBeanRegistration,
DynamicMBean,
NotificationEmitter {
    private static final Log log = LogFactory.getLog((Class)MBeanGBeanBridge.class);
    private final Kernel kernel;
    private final ObjectName objectName;
    private final MBeanInfo mbeanInfo;
    private final NotificationBroadcasterSupport notificationBroadcaster = new NotificationBroadcasterSupport();
    private final LifecycleBridge lifecycleBridge;

    public MBeanGBeanBridge(Kernel kernel, ObjectName objectName, MBeanInfo mbeanInfo) {
        this.kernel = kernel;
        this.objectName = objectName;
        this.mbeanInfo = mbeanInfo;
        this.lifecycleBridge = new LifecycleBridge(objectName, this.notificationBroadcaster);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
        if (Boolean.TRUE.equals(registrationDone)) {
            this.kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)this.lifecycleBridge, this.objectName);
            this.lifecycleBridge.loaded(this.objectName);
        }
    }

    public void preDeregister() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener((LifecycleListener)this.lifecycleBridge);
        this.lifecycleBridge.unloaded(this.objectName);
    }

    public void postDeregister() {
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public Object getAttribute(String attributeName) throws ReflectionException, AttributeNotFoundException {
        try {
            return this.kernel.getAttribute(this.objectName, attributeName);
        }
        catch (NoSuchAttributeException e) {
            throw new AttributeNotFoundException(attributeName);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws ReflectionException, AttributeNotFoundException {
        String attributeName = attribute.getName();
        Object attributeValue = attribute.getValue();
        try {
            this.kernel.setAttribute(this.objectName, attributeName, attributeValue);
        }
        catch (NoSuchAttributeException e) {
            throw new AttributeNotFoundException(attributeName);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList results = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            try {
                Object value = this.getAttribute(name);
                results.add(new Attribute(name, value));
                continue;
            }
            catch (JMException e) {
                log.warn((Object)("Exception while getting attribute " + name), (Throwable)e);
            }
        }
        return results;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList(attributes.size());
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            try {
                this.setAttribute(attribute);
                results.add(attribute);
            }
            catch (JMException e) {
                log.warn((Object)("Exception while setting attribute " + attribute.getName()), (Throwable)e);
            }
        }
        return results;
    }

    public Object invoke(String operationName, Object[] arguments, String[] types) throws ReflectionException {
        try {
            return this.kernel.invoke(this.objectName, operationName, arguments, types);
        }
        catch (NoSuchOperationException e) {
            throw new ReflectionException(new NoSuchMethodException(new GOperationSignature(operationName, types).toString()));
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(NotificationType.TYPES, "javax.management.Notification", "J2EE Notifications")};
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    public String toString() {
        return this.objectName.toString();
    }

    private static class LifecycleBridge
    implements LifecycleListener {
        private long sequence;
        private final ObjectName mbeanGBeanName;
        private final NotificationBroadcasterSupport notificationBroadcaster;

        public LifecycleBridge(ObjectName mbeanGBeanName, NotificationBroadcasterSupport notificationBroadcaster) {
            this.mbeanGBeanName = mbeanGBeanName;
            this.notificationBroadcaster = notificationBroadcaster;
        }

        public void loaded(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.object.created", objectName, this.nextSequence()));
            }
        }

        public void starting(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.starting", objectName, this.nextSequence()));
            }
        }

        public void running(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.running", objectName, this.nextSequence()));
            }
        }

        public void stopping(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.stopping", objectName, this.nextSequence()));
            }
        }

        public void stopped(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.stopped", objectName, this.nextSequence()));
            }
        }

        public void failed(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.state.failed", objectName, this.nextSequence()));
            }
        }

        public void unloaded(ObjectName objectName) {
            if (this.mbeanGBeanName.equals(objectName)) {
                this.notificationBroadcaster.sendNotification(new Notification("j2ee.object.deleted", objectName, this.nextSequence()));
            }
        }

        public synchronized long nextSequence() {
            return this.sequence++;
        }
    }
}

