/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class LocalConfigStore
implements ConfigurationStore,
GBeanLifecycle {
    private static final String INDEX_NAME = "index.properties";
    private static final String BACKUP_NAME = "index.backup";
    private static final String DELETE_NAME = "index.delete";
    private final int REAPER_INTERVAL = 60000;
    private final Kernel kernel;
    private final ObjectName objectName;
    private final URI root;
    private final ServerInfo serverInfo;
    private final Properties index = new Properties();
    private final Properties pendingDeletionIndex = new Properties();
    private ConfigStoreReaper reaper;
    private final Log log;
    private File rootDir;
    private int maxId;
    public static final GBeanInfo GBEAN_INFO;

    public LocalConfigStore(File rootDir) {
        this.kernel = null;
        this.objectName = null;
        this.serverInfo = null;
        this.root = null;
        this.rootDir = rootDir;
        this.log = LogFactory.getLog((String)("LocalConfigStore:" + rootDir.getName()));
    }

    public LocalConfigStore(Kernel kernel, String objectName, URI root, ServerInfo serverInfo) throws MalformedObjectNameException {
        this.kernel = kernel;
        this.objectName = new ObjectName(objectName);
        this.root = root;
        this.serverInfo = serverInfo;
        this.log = LogFactory.getLog((String)("LocalConfigStore:" + root.toString()));
    }

    public String getObjectName() {
        return this.objectName.toString();
    }

    public synchronized void doStart() throws FileNotFoundException, IOException {
        if (this.rootDir == null) {
            this.rootDir = this.serverInfo == null ? new File(this.root) : new File(this.serverInfo.resolve(this.root));
            if (!this.rootDir.isDirectory()) {
                throw new FileNotFoundException("Store root does not exist or is not a directory: " + this.rootDir);
            }
        }
        this.index.clear();
        File indexfile = new File(this.rootDir, INDEX_NAME);
        try {
            this.index.load(new BufferedInputStream(new FileInputStream(indexfile)));
            Iterator<Object> i = this.index.values().iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                this.maxId = Math.max(this.maxId, Integer.parseInt(id));
            }
        }
        catch (FileNotFoundException e) {
            this.maxId = 0;
        }
        File pendingDeletionFile = new File(this.rootDir, DELETE_NAME);
        try {
            this.pendingDeletionIndex.load(new BufferedInputStream(new FileInputStream(pendingDeletionFile)));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        this.reaper = new ConfigStoreReaper(60000);
        Thread t = new Thread((Runnable)this.reaper, "Geronimo Config Store Reaper");
        t.setDaemon(true);
        t.start();
    }

    public void doStop() {
        if (this.reaper != null) {
            this.reaper.close();
        }
    }

    public void doFail() {
        if (this.reaper != null) {
            this.reaper.close();
        }
    }

    private void saveIndex() throws IOException {
        File indexFile = new File(this.rootDir, INDEX_NAME);
        File backupFile = new File(this.rootDir, BACKUP_NAME);
        if (backupFile.exists()) {
            backupFile.delete();
        }
        indexFile.renameTo(backupFile);
        FileOutputStream fos = new FileOutputStream(indexFile);
        try {
            BufferedOutputStream os = new BufferedOutputStream(fos);
            this.index.store(os, null);
            os.close();
            fos = null;
        }
        catch (IOException e) {
            if (fos != null) {
                fos.close();
            }
            indexFile.delete();
            backupFile.renameTo(indexFile);
            throw e;
        }
    }

    private void saveDeleteIndex() throws IOException {
        File deleteFile = new File(this.rootDir, DELETE_NAME);
        FileOutputStream fos = new FileOutputStream(deleteFile);
        try {
            BufferedOutputStream os = new BufferedOutputStream(fos);
            this.pendingDeletionIndex.store(os, null);
            os.close();
            fos = null;
        }
        catch (IOException e) {
            if (fos != null) {
                fos.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createNewConfigurationDir() {
        String newId;
        File configurationDir;
        do {
            LocalConfigStore localConfigStore = this;
            synchronized (localConfigStore) {
                newId = Integer.toString(++this.maxId);
            }
        } while ((configurationDir = new File(this.rootDir, newId)).exists());
        configurationDir.mkdir();
        return configurationDir;
    }

    public URI install(URL source) throws IOException, InvalidConfigException {
        return (URI)this.install2(source).getAttribute("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GBeanData install2(URL source) throws IOException, InvalidConfigException {
        URI configId;
        GBeanData config;
        File configurationDir = this.createNewConfigurationDir();
        InputStream is = source.openStream();
        try {
            LocalConfigStore.unpack(configurationDir, is);
        }
        catch (IOException e) {
            LocalConfigStore.delete(configurationDir);
            throw e;
        }
        finally {
            is.close();
        }
        try {
            config = this.loadConfig(configurationDir);
            configId = (URI)config.getAttribute("id");
            this.index.setProperty(configId.toString(), configurationDir.getName());
        }
        catch (Exception e) {
            LocalConfigStore.delete(configurationDir);
            throw new InvalidConfigException("Unable to get ID from downloaded configuration", (Throwable)e);
        }
        LocalConfigStore localConfigStore = this;
        synchronized (localConfigStore) {
            this.saveIndex();
        }
        this.log.debug((Object)("Installed configuration (URL) " + configId + " in location " + configurationDir.getName()));
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ConfigurationData configurationData, File source) throws IOException, InvalidConfigException {
        if (!source.isDirectory()) {
            throw new InvalidConfigException("Source must be a directory: source=" + source);
        }
        if (!source.getParentFile().equals(this.rootDir)) {
            throw new InvalidConfigException("Source must be within the config store: source=" + source + ", configStoreDir=" + this.rootDir);
        }
        ExecutableConfigurationUtil.writeConfiguration(configurationData, source);
        LocalConfigStore localConfigStore = this;
        synchronized (localConfigStore) {
            this.index.setProperty(configurationData.getId().toString(), source.getName());
            this.saveIndex();
        }
        this.log.debug((Object)("Installed configuration (file) " + configurationData.getId() + " in location " + source.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall(URI configID) throws NoSuchConfigException, IOException {
        File configDir;
        String id = configID.toString();
        Object object = this;
        synchronized (object) {
            String storeID = this.index.getProperty(id);
            if (storeID == null) {
                throw new NoSuchConfigException();
            }
            configDir = new File(this.rootDir, storeID);
            this.index.remove(id);
            this.saveIndex();
        }
        LocalConfigStore.delete(configDir);
        if (!configDir.exists()) {
            this.log.debug((Object)("Uninstalled configuration " + configID));
        } else {
            this.log.debug((Object)("Uninstalled configuration, but could not delete ConfigStore directory for " + configID));
            object = this.pendingDeletionIndex;
            synchronized (object) {
                this.pendingDeletionIndex.setProperty(configDir.toString(), id);
                this.saveDeleteIndex();
            }
        }
    }

    public synchronized ObjectName loadConfiguration(URI configId) throws NoSuchConfigException, IOException, InvalidConfigException {
        ObjectName name;
        GBeanData config = this.loadConfig(this.getRoot(configId));
        try {
            name = Configuration.getConfigurationObjectName((URI)configId);
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Cannot convert id to ObjectName: ", (Throwable)e);
        }
        config.setName(name);
        config.setAttribute("baseURL", (Object)this.getRoot(configId).toURL());
        try {
            this.kernel.loadGBean(config, Configuration.class.getClassLoader());
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to register configuration", (Throwable)e);
        }
        this.log.debug((Object)("Loaded Configuration " + name));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listConfigurations() {
        ArrayList<ConfigurationInfo> configs;
        LocalConfigStore localConfigStore = this;
        synchronized (localConfigStore) {
            configs = new ArrayList<ConfigurationInfo>(this.index.size());
            Iterator<Object> i = this.index.keySet().iterator();
            while (i.hasNext()) {
                URI configId = URI.create((String)i.next());
                try {
                    State state;
                    ObjectName configName = Configuration.getConfigurationObjectName((URI)configId);
                    if (this.kernel.isLoaded(configName)) {
                        try {
                            state = State.fromInt((int)this.kernel.getGBeanState(configName));
                        }
                        catch (Exception e) {
                            state = null;
                        }
                    } else {
                        state = State.STOPPED;
                    }
                    GBeanData bean = this.loadConfig(this.getRoot(configId));
                    ConfigurationModuleType type = (ConfigurationModuleType)bean.getAttribute("type");
                    configs.add(new ConfigurationInfo(this.objectName, configId, state, type));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Unable get configuration info for configuration " + configId), (Throwable)e);
                }
            }
        }
        return configs;
    }

    public synchronized boolean containsConfiguration(URI configID) {
        return this.index.getProperty(configID.toString()) != null;
    }

    private synchronized File getRoot(URI configID) throws NoSuchConfigException {
        String id = this.index.getProperty(configID.toString());
        if (id == null) {
            throw new NoSuchConfigException("No such config: " + configID);
        }
        return new File(this.rootDir, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GBeanData loadConfig(File configRoot) throws IOException, InvalidConfigException {
        File file = new File(configRoot, "META-INF/config.ser");
        if (!file.isFile()) {
            throw new InvalidConfigException("Configuration does not contain a META-INF/config.ser file");
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
            GBeanData config = new GBeanData();
            try {
                config.readExternal((ObjectInput)ois);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigException("Unable to read attribute ", (Throwable)e);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to set attribute ", (Throwable)e);
            }
            GBeanData gBeanData = config;
            return gBeanData;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File to, InputStream from) throws IOException {
        ZipInputStream zis = new ZipInputStream(from);
        try {
            ZipEntry entry;
            byte[] buffer = new byte[4096];
            while ((entry = zis.getNextEntry()) != null) {
                File out = new File(to, entry.getName());
                if (entry.isDirectory()) {
                    out.mkdirs();
                    continue;
                }
                if (entry.getName().equals("META-INF/startup-jar")) continue;
                out.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(out);
                try {
                    int count;
                    while ((count = zis.read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, count);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            LocalConfigStore.delete(to);
            throw e;
        }
    }

    private static void delete(File root) throws IOException {
        File[] files = root.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                LocalConfigStore.delete(file);
                continue;
            }
            file.delete();
        }
        root.delete();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)LocalConfigStore.class, (String)"ConfigurationStore");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("root", URI.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(ConfigurationStore.class);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "root", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    class ConfigStoreReaper
    implements Runnable {
        private final int reaperInterval;
        private volatile boolean done = false;

        public ConfigStoreReaper(int reaperInterval) {
            this.reaperInterval = reaperInterval;
        }

        public void close() {
            this.done = true;
        }

        public void run() {
            LocalConfigStore.this.log.debug((Object)"ConfigStoreReaper started");
            while (!this.done) {
                try {
                    Thread.sleep(this.reaperInterval);
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.reap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reap() {
            Object dirName;
            if (LocalConfigStore.this.pendingDeletionIndex.size() == 0) {
                return;
            }
            Enumeration<?> list = LocalConfigStore.this.pendingDeletionIndex.propertyNames();
            boolean dirDeleted = false;
            while (list.hasMoreElements()) {
                dirName = (String)list.nextElement();
                File deleteFile = new File((String)dirName);
                try {
                    LocalConfigStore.delete(deleteFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (deleteFile.exists()) continue;
                String configName = LocalConfigStore.this.pendingDeletionIndex.getProperty((String)dirName);
                LocalConfigStore.this.pendingDeletionIndex.remove(dirName);
                dirDeleted = true;
                LocalConfigStore.this.log.debug((Object)("Reaped configuration " + configName + " in directory " + (String)dirName));
            }
            if (dirDeleted) {
                try {
                    dirName = LocalConfigStore.this.pendingDeletionIndex;
                    synchronized (dirName) {
                        LocalConfigStore.this.saveDeleteIndex();
                    }
                }
                catch (IOException ioe) {
                    LocalConfigStore.this.log.warn((Object)"Error saving index.delete file.", (Throwable)ioe);
                }
            }
        }
    }
}

