/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.ServerOverride;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalAttributeManager
implements ManageableAttributeStore,
PersistentConfigurationList,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)LocalAttributeManager.class);
    private static final String CONFIG_FILE_PROPERTY = "org.apache.geronimo.config.file";
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String TEMP_EXTENSION = ".working";
    private static final int SAVE_BUFFER_MS = 5000;
    private final ServerInfo serverInfo;
    private final String configFile;
    private final boolean readOnly;
    private File attributeFile;
    private File backupFile;
    private File tempFile;
    private ServerOverride serverOverride;
    private Timer timer;
    private TimerTask currentTask;
    private boolean kernelFullyStarted;
    public static final GBeanInfo GBEAN_INFO;

    public LocalAttributeManager(String configFile, boolean readOnly, ServerInfo serverInfo) {
        this.configFile = System.getProperty(CONFIG_FILE_PROPERTY, configFile);
        this.readOnly = readOnly;
        this.serverInfo = serverInfo;
        this.serverOverride = new ServerOverride();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized Collection setAttributes(URI configurationName, Collection gbeanDatas, ClassLoader classLoader) throws InvalidConfigException {
        gbeanDatas = new ArrayList<GBeanData>(gbeanDatas);
        String configName = configurationName.toString();
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return gbeanDatas;
        }
        if (!configuration.isLoad()) {
            return Collections.EMPTY_LIST;
        }
        HashMap<ObjectName, GBeanData> datasByName = new HashMap<ObjectName, GBeanData>();
        Iterator<Object> iterator = gbeanDatas.iterator();
        while (iterator.hasNext()) {
            GBeanData gbeanData = (GBeanData)iterator.next();
            datasByName.put(gbeanData.getName(), gbeanData);
        }
        iterator = configuration.getGBeans().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object name = entry.getKey();
            GBeanOverride gbean = (GBeanOverride)entry.getValue();
            if (datasByName.containsKey(name) || gbean.getGBeanInfo() == null || !gbean.isLoad()) continue;
            if (!(name instanceof ObjectName)) {
                throw new InvalidConfigException("New GBeans must be specified with a full objectName: configuration=" + configName + " gbeanName=" + name);
            }
            ObjectName objectName = (ObjectName)name;
            GBeanInfo gbeanInfo = GBeanInfo.getGBeanInfo((String)gbean.getGBeanInfo(), (ClassLoader)classLoader);
            GBeanData gBeanData = new GBeanData(objectName, gbeanInfo);
            gbeanDatas.add(gBeanData);
        }
        iterator = gbeanDatas.iterator();
        while (iterator.hasNext()) {
            GBeanData data = (GBeanData)iterator.next();
            boolean load = this.setAttributes(data, configuration, configName, classLoader);
            if (load) continue;
            iterator.remove();
        }
        return gbeanDatas;
    }

    private synchronized boolean setAttributes(GBeanData data, ConfigurationOverride configuration, String configName, ClassLoader classLoader) throws InvalidConfigException {
        Map.Entry entry;
        ObjectName gbeanName = data.getName();
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean(gbeanName.getKeyProperty("name"));
        }
        if (gbean == null) {
            return true;
        }
        if (!gbean.isLoad()) {
            return false;
        }
        GBeanInfo gbeanInfo = data.getGBeanInfo();
        Iterator iterator = gbean.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String attributeName = (String)entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidConfigException("No attribute: " + attributeName + " for gbean: " + data.getName());
            }
            String valueString = (String)entry.getValue();
            Object value = this.getValue(attributeInfo, valueString, configName, gbeanName, classLoader);
            data.setAttribute(attributeName, value);
        }
        iterator = gbean.getReferences().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String referenceName = (String)entry.getKey();
            GReferenceInfo referenceInfo = gbeanInfo.getReference(referenceName);
            if (referenceInfo == null) {
                throw new InvalidConfigException("No reference: " + referenceName + " for gbean: " + data.getName());
            }
            Set referencePatterns = (Set)entry.getValue();
            data.setReferencePatterns(referenceName, referencePatterns);
        }
        return true;
    }

    private synchronized Object getValue(GAttributeInfo attribute, String value, String configurationName, ObjectName gbeanName, ClassLoader classLoader) {
        if (value == null) {
            return null;
        }
        try {
            PropertyEditor editor = PropertyEditors.findEditor((String)attribute.getType(), (ClassLoader)classLoader);
            if (editor == null) {
                log.debug((Object)("Unable to parse attribute of type " + attribute.getType() + "; no editor found"));
                return null;
            }
            editor.setAsText(value);
            log.debug((Object)("Setting value for " + configurationName + "/" + gbeanName + "/" + attribute.getName() + " to value " + value));
            return editor.getValue();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to load attribute type " + attribute.getType()));
            return null;
        }
    }

    public synchronized void setValue(String configurationName, ObjectName gbeanName, GAttributeInfo attribute, Object value) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean(gbeanName.getKeyProperty("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true);
            configuration.addGBean(gbeanName, gbean);
        }
        try {
            gbean.setAttribute(attribute.getName(), value, attribute.getType());
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
            return;
        }
    }

    public synchronized void setReferencePattern(String configurationName, ObjectName gbeanName, GReferenceInfo reference, ObjectName pattern) {
        this.setReferencePatterns(configurationName, gbeanName, reference, Collections.singleton(pattern));
    }

    public synchronized void setReferencePatterns(String configurationName, ObjectName gbeanName, GReferenceInfo reference, Set patterns) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean(gbeanName.getKeyProperty("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true);
            configuration.addGBean(gbeanName, gbean);
        }
        gbean.setReferencePatterns(reference.getName(), patterns);
        this.attributeChanged();
    }

    public synchronized void setShouldLoad(String configurationName, ObjectName gbeanName, boolean load) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean(gbeanName.getKeyProperty("name"));
        }
        if (gbean == null) {
            gbean = new GBeanOverride(gbeanName, load);
            configuration.addGBean(gbeanName, gbean);
        } else {
            gbean.setLoad(load);
        }
        this.attributeChanged();
    }

    public void addGBean(String configurationName, GBeanData gbeanData) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName);
        if (configuration == null) {
            log.debug((Object)("Can not add GBean; Configuration not found " + configurationName));
            return;
        }
        try {
            GBeanOverride gbean = new GBeanOverride(gbeanData);
            configuration.addGBean(gbean);
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
            return;
        }
    }

    public synchronized void load() throws IOException {
        this.ensureParentDirectory();
        if (!this.attributeFile.exists()) {
            return;
        }
        InputSource in = new InputSource(new FileInputStream(this.attributeFile));
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        try {
            Document doc = dfactory.newDocumentBuilder().parse(in);
            Element root = doc.getDocumentElement();
            this.serverOverride = new ServerOverride(root);
        }
        catch (SAXException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
    }

    public synchronized void save() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.ensureParentDirectory();
        if (!this.tempFile.exists() && !this.tempFile.createNewFile()) {
            throw new IOException("Unable to create manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        if (!this.tempFile.canWrite()) {
            throw new IOException("Unable to write to manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter((Writer)new FileWriter(this.tempFile), true);
        this.serverOverride.writeXml(out);
        out.close();
        if (this.backupFile.exists() && !this.backupFile.delete()) {
            throw new IOException("Unable to delete old backup file in order to back up current manageable attribute working file for save");
        }
        if (this.attributeFile.exists() && !this.attributeFile.renameTo(this.backupFile)) {
            throw new IOException("Unable to rename " + this.attributeFile.getAbsolutePath() + " to " + this.backupFile.getAbsolutePath() + " in order to back up manageable attribute save file");
        }
        if (!this.tempFile.renameTo(this.attributeFile)) {
            throw new IOException("EXTREMELY CRITICAL!  Unable to move manageable attributes working file to proper file name!  Configuration will revert to defaults unless this is manually corrected!  (could not rename " + this.tempFile.getAbsolutePath() + " to " + this.attributeFile.getAbsolutePath() + ")");
        }
    }

    public synchronized boolean isKernelFullyStarted() {
        return this.kernelFullyStarted;
    }

    public synchronized void setKernelFullyStarted(boolean kernelFullyStarted) {
        this.kernelFullyStarted = kernelFullyStarted;
    }

    public synchronized List restore() throws IOException {
        ArrayList<URI> configs = new ArrayList<URI>();
        Iterator iterator = this.serverOverride.getConfigurations().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ConfigurationOverride configuration = (ConfigurationOverride)entry.getValue();
            if (!configuration.isLoad()) continue;
            String configName = (String)entry.getKey();
            try {
                URI configID = new URI(configName);
                configs.add(configID);
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not construct URI configID for " + configName);
            }
        }
        return configs;
    }

    public synchronized void addConfiguration(String configurationName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        configuration.setLoad(true);
        this.attributeChanged();
    }

    public synchronized void removeConfiguration(String configName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            log.error((Object)("Trying to stop unknown configuration: " + configName));
        } else {
            if (configuration.getGBeans().isEmpty()) {
                this.serverOverride.removeConfiguration(configName);
            } else {
                configuration.setLoad(false);
            }
            this.attributeChanged();
        }
    }

    public synchronized void doStart() throws Exception {
        this.load();
        if (!this.readOnly) {
            this.timer = new Timer();
        }
        log.debug((Object)("Started LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStop() throws Exception {
        boolean doSave = false;
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                    doSave = true;
                }
            }
        }
        if (doSave) {
            this.save();
        }
        log.debug((Object)("Stopped LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
        this.serverOverride = new ServerOverride();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doFail() {
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                }
            }
        }
        this.serverOverride = new ServerOverride();
    }

    private synchronized void ensureParentDirectory() throws IOException {
        File parent;
        if (this.attributeFile == null) {
            this.attributeFile = this.serverInfo.resolve(this.configFile);
            this.tempFile = new File(this.attributeFile.getAbsolutePath() + TEMP_EXTENSION);
            this.backupFile = new File(this.attributeFile.getAbsolutePath() + BACKUP_EXTENSION);
        }
        if (!(parent = this.attributeFile.getParentFile()).isDirectory() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory for list:" + parent);
        }
        if (!parent.canRead() || !parent.canWrite()) {
            throw new IOException("Unable to write manageable attribute files to directory " + parent.getAbsolutePath());
        }
    }

    private synchronized void attributeChanged() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        if (this.timer != null) {
            this.currentTask = new TimerTask(){

                public void run() {
                    try {
                        LocalAttributeManager.this.save();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error saving attributes", (Throwable)e);
                    }
                }
            };
            this.timer.schedule(this.currentTask, 5000L);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)LocalAttributeManager.class, (String)"AttributeStore");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.addAttribute("readOnly", Boolean.TYPE, true);
        infoFactory.addInterface(ManageableAttributeStore.class);
        infoFactory.addInterface(PersistentConfigurationList.class);
        infoFactory.setConstructor(new String[]{"configFile", "readOnly", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

