/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.util.EncryptionManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class GBeanOverride {
    private final Object name;
    private boolean load;
    private final Map attributes = new LinkedHashMap();
    private final Map references = new LinkedHashMap();
    private final String gbeanInfo;

    public GBeanOverride(String name, boolean load) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
    }

    public GBeanOverride(ObjectName name, boolean load) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
    }

    public GBeanOverride(GBeanData gbeanData) throws InvalidAttributeException {
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        this.gbeanInfo = gbeanInfo.getSourceClass();
        if (this.gbeanInfo == null) {
            throw new IllegalArgumentException("GBeanInfo must have a source class set");
        }
        this.name = gbeanData.getName();
        this.load = true;
        Iterator iterator = gbeanData.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String attributeName = (String)entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidAttributeException("No attribute: " + attributeName + " for gbean: " + gbeanData.getName());
            }
            Object attributeValue = entry.getValue();
            this.setAttribute(attributeName, attributeValue, attributeInfo.getType());
        }
        this.references.putAll(gbeanData.getReferences());
    }

    public GBeanOverride(Element gbean) throws MalformedObjectNameException {
        String nameString = gbean.getAttribute("name");
        this.name = nameString.indexOf(58) > -1 ? ObjectName.getInstance(nameString) : nameString;
        String gbeanInfoString = gbean.getAttribute("gbeanInfo");
        this.gbeanInfo = gbeanInfoString.length() > 0 ? gbeanInfoString : null;
        if (this.gbeanInfo != null && !(this.name instanceof ObjectName)) {
            throw new MalformedObjectNameException("A gbean element using the gbeanInfo attribute must be specified using a full ObjectName: name=" + nameString);
        }
        String loadString = gbean.getAttribute("load");
        this.load = !"false".equals(loadString);
        NodeList attributes = gbean.getElementsByTagName("attribute");
        for (int a = 0; a < attributes.getLength(); ++a) {
            Element attribute = (Element)attributes.item(a);
            String attributeName = attribute.getAttribute("name");
            String attributeValue = (String)EncryptionManager.decrypt((String)GBeanOverride.getContentsAsText(attribute));
            this.setAttribute(attributeName, attributeValue);
        }
        NodeList references = gbean.getElementsByTagName("reference");
        for (int r = 0; r < references.getLength(); ++r) {
            Element reference = (Element)references.item(r);
            String referenceName = reference.getAttribute("name");
            LinkedHashSet<ObjectName> objectNamePatterns = new LinkedHashSet<ObjectName>();
            NodeList patterns = reference.getElementsByTagName("pattern");
            for (int p = 0; p < references.getLength(); ++p) {
                Element pattern = (Element)patterns.item(p);
                NodeList gbeanNames = pattern.getElementsByTagName("gbean-name");
                if (gbeanNames.getLength() != 1) {
                    throw new MalformedObjectNameException("pattern does not contain a valid gbean-name: name=" + nameString + " referenceName=" + referenceName);
                }
                String value = GBeanOverride.getContentsAsText((Element)gbeanNames.item(0));
                ObjectName objectNamePattern = new ObjectName(value);
                objectNamePatterns.add(objectNamePattern);
            }
            this.setReferencePatterns(referenceName, objectNamePatterns);
        }
    }

    private static String getContentsAsText(Element element) {
        String value = "";
        NodeList text = element.getChildNodes();
        for (int t = 0; t < text.getLength(); ++t) {
            Node n = text.item(t);
            if (n.getNodeType() != 3) continue;
            value = value + n.getNodeValue();
        }
        return value.trim();
    }

    public Object getName() {
        return this.name;
    }

    public String getGBeanInfo() {
        return this.gbeanInfo;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        return (String)this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue, String attributeType) throws InvalidAttributeException {
        String stringValue = GBeanOverride.getAsText(attributeValue, attributeType);
        this.attributes.put(attributeName, stringValue);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public Map getReferences() {
        return this.references;
    }

    public Set getReferencePatterns(String name) {
        return (Set)this.references.get(name);
    }

    public void setReferencePattern(String name, ObjectName pattern) {
        this.setReferencePatterns(name, Collections.singleton(pattern));
    }

    public void setReferencePatterns(String name, Set patterns) {
        this.references.put(name, patterns);
    }

    public void writeXml(PrintWriter out) {
        String name;
        Map.Entry entry;
        String gbeanName = this.name instanceof String ? (String)this.name : ((ObjectName)this.name).getCanonicalName();
        out.print("    <gbean name=\"" + gbeanName + "\"");
        if (this.gbeanInfo != null) {
            out.print(" gbeanInfo=\"" + this.gbeanInfo + "\"");
        }
        if (!this.load) {
            out.print(" load=\"false\"");
        }
        out.println(">");
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name.toLowerCase().indexOf("password") > -1) {
                value = EncryptionManager.encrypt((Serializable)((Object)value));
            }
            out.println("      <attribute name=\"" + name + "\">" + value + "</attribute>");
        }
        iterator = this.references.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            Set patterns = (Set)entry.getValue();
            out.println("      <reference name=\"" + name + "\">");
            Iterator patternIterator = patterns.iterator();
            while (patternIterator.hasNext()) {
                ObjectName pattern = (ObjectName)patternIterator.next();
                out.print("          <pattern><gbean-name>");
                out.print(pattern.getCanonicalName());
                out.println("</gbean-name></pattern>");
            }
            out.println("      </reference>");
        }
        out.println("    </gbean>");
    }

    public static String getAsText(Object value, String type) throws InvalidAttributeException {
        try {
            String attributeStringValue = null;
            if (value != null) {
                PropertyEditor editor = PropertyEditors.findEditor((String)type, (ClassLoader)GBeanOverride.class.getClassLoader());
                if (editor == null) {
                    throw new InvalidAttributeException("Unable to format attribute of type " + type + "; no editor found");
                }
                editor.setValue(value);
                attributeStringValue = editor.getAsText();
            }
            return attributeStringValue;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidAttributeException("Unable to store attribute type " + type);
        }
    }
}

