/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ConfigurationOverride {
    private final String name;
    private boolean load;
    private final Map gbeans = new LinkedHashMap();

    public ConfigurationOverride(String name, boolean load) {
        this.name = name;
        this.load = load;
    }

    public ConfigurationOverride(Element element) throws MalformedObjectNameException {
        this.name = element.getAttribute("name");
        String loadConfigString = element.getAttribute("load");
        this.load = !"false".equals(loadConfigString);
        NodeList gbeans = element.getElementsByTagName("gbean");
        for (int g = 0; g < gbeans.getLength(); ++g) {
            Element gbeanElement = (Element)gbeans.item(g);
            GBeanOverride gbean = new GBeanOverride(gbeanElement);
            this.addGBean(gbean);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public GBeanOverride getGBean(String gbeanName) {
        return (GBeanOverride)this.gbeans.get(gbeanName);
    }

    public void addGBean(GBeanOverride gbean) {
        this.gbeans.put(gbean.getName(), gbean);
    }

    public void addGBean(String gbeanName, GBeanOverride gbean) {
        this.gbeans.put(gbeanName, gbean);
    }

    public Map getGBeans() {
        return this.gbeans;
    }

    public GBeanOverride getGBean(ObjectName gbeanName) {
        return (GBeanOverride)this.gbeans.get(gbeanName);
    }

    public void addGBean(ObjectName gbeanName, GBeanOverride gbean) {
        this.gbeans.put(gbeanName, gbean);
    }

    public void writeXml(PrintWriter out) {
        out.print("  <configuration name=\"" + this.name + "\"");
        if (!this.load) {
            out.print(" load=\"false\"");
        }
        out.println(">");
        Iterator gb = this.gbeans.entrySet().iterator();
        while (gb.hasNext()) {
            Map.Entry gbean = gb.next();
            GBeanOverride gbeanOverride = (GBeanOverride)gbean.getValue();
            gbeanOverride.writeXml(out);
        }
        out.println("  </configuration>");
    }
}

