/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.security.SecurityServiceImpl;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.server.JaasLoginModuleConfiguration;

public class GeronimoLoginConfiguration
extends Configuration
implements GBeanLifecycle,
ReferenceCollectionListener {
    private final Log log = LogFactory.getLog((Class)GeronimoLoginConfiguration.class);
    private static Map entries = new Hashtable();
    private Configuration oldConfiguration;
    private Collection configurations = Collections.EMPTY_SET;
    private static final GBeanInfo GBEAN_INFO;

    public Collection getConfigurations() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        return this.configurations;
    }

    public void setConfigurations(Collection configurations) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ReferenceCollection ref = (ReferenceCollection)configurations;
        ref.addReferenceCollectionListener((ReferenceCollectionListener)this);
        this.configurations = configurations;
        Iterator iter = configurations.iterator();
        while (iter.hasNext()) {
            this.addConfiguration((ConfigurationEntryFactory)iter.next());
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry entry = (AppConfigurationEntry)entries.get(name);
        if (entry == null) {
            return null;
        }
        return new AppConfigurationEntry[]{entry};
    }

    public void refresh() {
    }

    public void memberAdded(ReferenceCollectionEvent event) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ConfigurationEntryFactory factory = (ConfigurationEntryFactory)event.getMember();
        this.addConfiguration(factory);
    }

    public void memberRemoved(ReferenceCollectionEvent event) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ConfigurationEntryFactory factory = (ConfigurationEntryFactory)event.getMember();
        entries.remove(factory.getConfigurationName());
        this.log.debug((Object)("Removed Application Configuration Entry " + factory.getConfigurationName()));
    }

    private final void addConfiguration(ConfigurationEntryFactory factory) {
        JaasLoginModuleConfiguration config = factory.generateConfiguration();
        if (config.getLoginDomainName() == null) {
            throw new IllegalArgumentException("A login module to be registered standalone must have a domain name!");
        }
        if (entries.containsKey(factory.getConfigurationName())) {
            throw new IllegalArgumentException("ConfigurationEntry already registered");
        }
        AppConfigurationEntry ace = new AppConfigurationEntry(config.getLoginModuleClassName(), config.getFlag().getFlag(), config.getOptions());
        entries.put(factory.getConfigurationName(), ace);
        this.log.debug((Object)("Added Application Configuration Entry " + factory.getConfigurationName()));
    }

    public void doStart() throws Exception {
        try {
            this.oldConfiguration = Configuration.getConfiguration();
        }
        catch (SecurityException e) {
            this.oldConfiguration = null;
        }
        Configuration.setConfiguration(this);
        this.log.debug((Object)"Installed Geronimo login configuration");
    }

    public void doStop() throws Exception {
        Configuration.setConfiguration(this.oldConfiguration);
        Iterator iter = entries.keySet().iterator();
        while (iter.hasNext()) {
            this.log.debug((Object)("Removed Application Configuration Entry " + iter.next()));
        }
        entries.clear();
        this.log.debug((Object)"Uninstalled Geronimo login configuration");
    }

    public void doFail() {
        Configuration.setConfiguration(this.oldConfiguration);
        this.log.debug((Object)"Uninstalled Geronimo login configuration");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)GeronimoLoginConfiguration.class);
        infoFactory.addReference("Configurations", ConfigurationEntryFactory.class, null);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

