/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.log;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.geronimo.kernel.log.GeronimoLogging;

public class BootstrapJdk14Log
implements Log {
    private Logger logger = null;

    public BootstrapJdk14Log(String name) {
        this.logger = Logger.getLogger(name);
    }

    private void log(Level level, String messge, Throwable throwable) {
        if (this.logger.isLoggable(level)) {
            StackTraceElement[] locations = new Throwable().getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            if (locations != null && locations.length > 3) {
                StackTraceElement caller = locations[3];
                cname = caller.getClassName();
                method = caller.getMethodName();
            }
            if (throwable == null) {
                this.logger.logp(level, cname, method, messge);
            } else {
                this.logger.logp(level, cname, method, messge, throwable);
            }
        }
    }

    public void debug(Object message) {
        this.log(Level.FINE, String.valueOf(message), null);
    }

    public void debug(Object message, Throwable exception) {
        this.log(Level.FINE, String.valueOf(message), exception);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, String.valueOf(message), null);
    }

    public void error(Object message, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf(message), exception);
    }

    public void fatal(Object message) {
        this.log(Level.SEVERE, String.valueOf(message), null);
    }

    public void fatal(Object message, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf(message), exception);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void info(Object message) {
        this.log(Level.INFO, String.valueOf(message), null);
    }

    public void info(Object message, Throwable exception) {
        this.log(Level.INFO, String.valueOf(message), exception);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void trace(Object message) {
        this.log(Level.FINEST, String.valueOf(message), null);
    }

    public void trace(Object message, Throwable exception) {
        this.log(Level.FINEST, String.valueOf(message), exception);
    }

    public void warn(Object message) {
        this.log(Level.WARNING, String.valueOf(message), null);
    }

    public void warn(Object message, Throwable exception) {
        this.log(Level.WARNING, String.valueOf(message), exception);
    }

    static {
        Logger root = Logger.getLogger("");
        GeronimoLogging geronimoLevel = GeronimoLogging.getDefaultLevel();
        Level javaLevel = geronimoLevel == GeronimoLogging.TRACE ? Level.FINEST : (geronimoLevel == GeronimoLogging.DEBUG ? Level.FINE : (geronimoLevel == GeronimoLogging.INFO ? Level.INFO : (geronimoLevel == GeronimoLogging.WARN ? Level.WARNING : Level.SEVERE)));
        root.setLevel(javaLevel);
        Handler[] handlers = root.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            if (!(handlers[index] instanceof ConsoleHandler)) continue;
            handlers[index].setLevel(javaLevel);
        }
    }
}

