/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.net.URI;
import java.util.Collection;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManagerImpl;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;

public class EditableConfigurationManagerImpl
extends ConfigurationManagerImpl
implements EditableConfigurationManager {
    public static final GBeanInfo GBEAN_INFO;

    public EditableConfigurationManagerImpl(Kernel kernel, Collection stores, ManageableAttributeStore attributeStore, PersistentConfigurationList configurationList) {
        super(kernel, stores, attributeStore, configurationList);
    }

    public void addGBeanToConfiguration(URI configID, GBeanData gbean, boolean start) throws InvalidConfigException {
        try {
            ObjectName name = Configuration.getConfigurationObjectName(configID);
            this.kernel.invoke(name, "addGBean", new Object[]{gbean, start ? Boolean.TRUE : Boolean.FALSE}, new String[]{GBeanData.class.getName(), Boolean.TYPE.getName()});
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to add GBean to configuration", e);
        }
        this.attributeStore.addGBean(configID.toString(), gbean);
    }

    public void removeGBeanFromConfiguration(URI configID, ObjectName gbean) throws GBeanNotFoundException, InvalidConfigException {
        try {
            ObjectName name = Configuration.getConfigurationObjectName(configID);
            Boolean result = (Boolean)this.kernel.invoke(name, "containsGBean", new Object[]{gbean}, new String[]{ObjectName.class.getName()});
            if (!result.booleanValue()) {
                throw new GBeanNotFoundException(gbean);
            }
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to add GBean to configuration", e);
        }
        try {
            if (this.kernel.getGBeanState(gbean) == 1) {
                this.kernel.stopGBean(gbean);
            }
            this.kernel.unloadGBean(gbean);
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
        this.attributeStore.setShouldLoad(configID.toString(), gbean, false);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EditableConfigurationManagerImpl.class, ConfigurationManagerImpl.GBEAN_INFO, "ConfigurationManager");
        infoFactory.addInterface(EditableConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "Stores", "AttributeStore", "PersistentConfigurationList"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

